/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.marketdata.CandleStick;
import org.knowm.xchange.dto.marketdata.CandleStickData;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.dto.meta.WalletHealth;
import org.knowm.xchange.dto.trade.FixedRateLoanOrder;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.poloniex.PoloniexUtils;
import org.knowm.xchange.poloniex.dto.LoanInfo;
import org.knowm.xchange.poloniex.dto.account.PoloniexBalance;
import org.knowm.xchange.poloniex.dto.account.PoloniexLoan;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexChartData;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexCurrencyInfo;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexDepth;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexMarketData;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexPublicTrade;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexTicker;
import org.knowm.xchange.poloniex.dto.trade.PoloniexAdjustment;
import org.knowm.xchange.poloniex.dto.trade.PoloniexDeposit;
import org.knowm.xchange.poloniex.dto.trade.PoloniexDepositsWithdrawalsResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexOpenOrder;
import org.knowm.xchange.poloniex.dto.trade.PoloniexUserTrade;
import org.knowm.xchange.poloniex.dto.trade.PoloniexWithdrawal;

public class PoloniexAdapters {
    public static Ticker adaptPoloniexTicker(PoloniexTicker poloniexTicker, CurrencyPair currencyPair) {
        PoloniexMarketData marketData = poloniexTicker.getPoloniexMarketData();
        return PoloniexAdapters.adaptPoloniexTicker(marketData, currencyPair);
    }

    public static Ticker adaptPoloniexTicker(PoloniexMarketData marketData, CurrencyPair currencyPair) {
        BigDecimal last = marketData.getLast();
        BigDecimal bid = marketData.getHighestBid();
        BigDecimal ask = marketData.getLowestAsk();
        BigDecimal high = marketData.getHigh24hr();
        BigDecimal low = marketData.getLow24hr();
        BigDecimal volume = marketData.getQuoteVolume();
        BigDecimal percentageChange = marketData.getPercentChange();
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).percentageChange(percentageChange.multiply(new BigDecimal("100"), new MathContext(8))).build();
    }

    public static OrderBook adaptPoloniexDepth(PoloniexDepth depth, CurrencyPair currencyPair) {
        List<LimitOrder> asks = PoloniexAdapters.adaptPoloniexPublicOrders(depth.getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = PoloniexAdapters.adaptPoloniexPublicOrders(depth.getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(null, asks, bids);
    }

    public static List<LimitOrder> adaptPoloniexPublicOrders(List<List<BigDecimal>> rawLevels, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>();
        for (List<BigDecimal> rawlevel : rawLevels) {
            LimitOrder limitOrder = new LimitOrder.Builder(orderType, (Instrument)currencyPair).originalAmount(rawlevel.get(1)).limitPrice(rawlevel.get(0)).build();
            orders.add(limitOrder);
        }
        return orders;
    }

    public static Trades adaptPoloniexPublicTrades(PoloniexPublicTrade[] poloniexPublicTrades, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        for (PoloniexPublicTrade poloniexTrade : poloniexPublicTrades) {
            trades.add(PoloniexAdapters.adaptPoloniexPublicTrade(poloniexTrade, currencyPair));
        }
        return new Trades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static Trade adaptPoloniexPublicTrade(PoloniexPublicTrade poloniexTrade, CurrencyPair currencyPair) {
        Order.OrderType type = poloniexTrade.getType().equalsIgnoreCase("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        Date timestamp = PoloniexUtils.stringToDate(poloniexTrade.getDate());
        return new Trade.Builder().type(type).originalAmount(poloniexTrade.getAmount()).currencyPair(currencyPair).price(poloniexTrade.getRate()).timestamp(timestamp).id(poloniexTrade.getTradeID()).build();
    }

    public static List<Balance> adaptPoloniexBalances(HashMap<String, PoloniexBalance> poloniexBalances) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (Map.Entry<String, PoloniexBalance> item : poloniexBalances.entrySet()) {
            Currency currency = Currency.getInstance((String)item.getKey());
            balances.add(new Balance(currency, null, item.getValue().getAvailable(), item.getValue().getOnOrders()));
        }
        return balances;
    }

    public static LoanInfo adaptPoloniexLoans(HashMap<String, PoloniexLoan[]> poloniexLoans) {
        HashMap loans = new HashMap();
        for (Map.Entry<String, PoloniexLoan[]> item : poloniexLoans.entrySet()) {
            ArrayList<FixedRateLoanOrder> loanOrders = new ArrayList<FixedRateLoanOrder>();
            for (PoloniexLoan poloniexLoan : item.getValue()) {
                Date date = PoloniexUtils.stringToDate(poloniexLoan.getDate());
                loanOrders.add(new FixedRateLoanOrder(Order.OrderType.ASK, poloniexLoan.getCurrency(), poloniexLoan.getAmount(), poloniexLoan.getRange(), poloniexLoan.getId(), date, poloniexLoan.getRate()));
            }
            loans.put(item.getKey(), loanOrders);
        }
        return new LoanInfo((List)loans.get("provided"), (List)loans.get("used"));
    }

    public static OpenOrders adaptPoloniexOpenOrders(Map<String, PoloniexOpenOrder[]> poloniexOpenOrders) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (String pairString : poloniexOpenOrders.keySet()) {
            CurrencyPair currencyPair = PoloniexUtils.toCurrencyPair(pairString);
            for (PoloniexOpenOrder openOrder : poloniexOpenOrders.get(pairString)) {
                openOrders.add(PoloniexAdapters.adaptPoloniexOpenOrder(openOrder, currencyPair));
            }
        }
        return new OpenOrders(openOrders);
    }

    public static LimitOrder adaptPoloniexOpenOrder(PoloniexOpenOrder openOrder, CurrencyPair currencyPair) {
        Order.OrderType type = openOrder.getType().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        Date timestamp = PoloniexUtils.stringToDate(openOrder.getDate());
        return new LimitOrder.Builder(type, (Instrument)currencyPair).limitPrice(openOrder.getRate()).originalAmount(openOrder.getStartingAmount()).cumulativeAmount(openOrder.getStartingAmount().subtract(openOrder.getAmount())).id(openOrder.getOrderNumber()).timestamp(timestamp).build();
    }

    public static UserTrade adaptPoloniexUserTrade(PoloniexUserTrade userTrade, CurrencyPair currencyPair) {
        String feeCurrencyCode;
        BigDecimal feeAmount;
        Order.OrderType orderType = userTrade.getType().equalsIgnoreCase("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = userTrade.getAmount();
        BigDecimal price = userTrade.getRate();
        Date date = PoloniexUtils.stringToDate(userTrade.getDate());
        String tradeId = String.valueOf(userTrade.getTradeID());
        String orderId = String.valueOf(userTrade.getOrderNumber());
        if (orderType == Order.OrderType.ASK) {
            feeAmount = amount.multiply(price).multiply(userTrade.getFee()).setScale(8, RoundingMode.DOWN);
            feeCurrencyCode = currencyPair.counter.getCurrencyCode();
        } else {
            feeAmount = amount.multiply(userTrade.getFee()).setScale(8, RoundingMode.DOWN);
            feeCurrencyCode = currencyPair.base.getCurrencyCode();
        }
        return UserTrade.builder().type(orderType).originalAmount(amount).currencyPair(currencyPair).price(price).timestamp(date).id(tradeId).orderId(orderId).feeAmount(feeAmount).feeCurrency(Currency.getInstance((String)feeCurrencyCode)).build();
    }

    public static ExchangeMetaData adaptToExchangeMetaData(Map<String, PoloniexCurrencyInfo> poloniexCurrencyInfo, Map<String, PoloniexMarketData> poloniexMarketData, ExchangeMetaData exchangeMetaData) {
        Map currencyMetaDataMap = exchangeMetaData.getCurrencies();
        CurrencyMetaData currencyArchetype = (CurrencyMetaData)currencyMetaDataMap.values().iterator().next();
        for (Map.Entry<String, PoloniexCurrencyInfo> entry : poloniexCurrencyInfo.entrySet()) {
            Currency ccy = Currency.getInstance((String)entry.getKey());
            if (!currencyMetaDataMap.containsKey(ccy)) {
                currencyMetaDataMap.put(ccy, currencyArchetype);
            }
            CurrencyMetaData currencyMetaData = (CurrencyMetaData)currencyMetaDataMap.get(ccy);
            WalletHealth walletHealth = WalletHealth.ONLINE;
            if (entry.getValue().isDelisted() || entry.getValue().isDisabled()) {
                walletHealth = WalletHealth.OFFLINE;
            }
            CurrencyMetaData currencyMetaDataUpdated = new CurrencyMetaData(currencyMetaData.getScale(), entry.getValue().getTxFee(), currencyMetaData.getMinWithdrawalAmount(), walletHealth);
            currencyMetaDataMap.put(ccy, currencyMetaDataUpdated);
        }
        Map marketMetaDataMap = exchangeMetaData.getInstruments();
        InstrumentMetaData marketArchetype = (InstrumentMetaData)marketMetaDataMap.values().iterator().next();
        for (String market : poloniexMarketData.keySet()) {
            CurrencyPair currencyPair = PoloniexUtils.toCurrencyPair(market);
            if (marketMetaDataMap.containsKey(currencyPair)) continue;
            marketMetaDataMap.put(currencyPair, marketArchetype);
        }
        return exchangeMetaData;
    }

    public static List<FundingRecord> adaptFundingRecords(PoloniexDepositsWithdrawalsResponse poloFundings) {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        for (PoloniexAdjustment a : poloFundings.getAdjustments()) {
            fundingRecords.add(PoloniexAdapters.adaptAdjustment(a));
        }
        for (PoloniexDeposit d : poloFundings.getDeposits()) {
            fundingRecords.add(PoloniexAdapters.adaptDeposit(d));
        }
        for (PoloniexWithdrawal w : poloFundings.getWithdrawals()) {
            fundingRecords.add(PoloniexAdapters.adaptWithdrawal(w));
        }
        return fundingRecords;
    }

    private static FundingRecord adaptAdjustment(PoloniexAdjustment a) {
        FundingRecord.Type type = FundingRecord.Type.OTHER_INFLOW;
        if (a.getReason().toLowerCase().contains("aidrop") || a.getReason().toLowerCase().contains("airdrop")) {
            type = FundingRecord.Type.AIRDROP;
        }
        return new FundingRecord(null, a.getTimestamp(), Currency.getInstance((String)a.getCurrency()), a.getAmount(), null, null, type, FundingRecord.Status.resolveStatus((String)a.getStatus()), null, null, a.getCategory() + ":" + a.getReason() + "\n" + a.getAdjustmentTitle() + "\n" + a.getAdjustmentDesc() + "\n" + a.getAdjustmentHelp());
    }

    private static FundingRecord adaptDeposit(PoloniexDeposit d) {
        return new FundingRecord(d.getAddress(), d.getTimestamp(), Currency.getInstance((String)d.getCurrency()), d.getAmount(), String.valueOf(d.getDepositNumber()), d.getTxid(), FundingRecord.Type.DEPOSIT, FundingRecord.Status.resolveStatus((String)d.getStatus()), null, null, d.getStatus());
    }

    private static FundingRecord adaptWithdrawal(PoloniexWithdrawal w) {
        String[] statusParts = w.getStatus().split(": *");
        String statusStr = statusParts[0];
        FundingRecord.Status status = FundingRecord.Status.resolveStatus((String)statusStr);
        String externalId = statusParts.length == 1 ? null : statusParts[1];
        BigDecimal feeAmount = w.getFee();
        return new FundingRecord(w.getAddress(), w.getTimestamp(), Currency.getInstance((String)w.getCurrency()), w.getAmount(), String.valueOf(w.getWithdrawalNumber()), externalId, FundingRecord.Type.WITHDRAWAL, status, null, feeAmount, w.getStatus());
    }

    public static LimitOrder adaptUserTradesToOrderStatus(String orderId, PoloniexUserTrade[] poloniexUserTrades) {
        if (poloniexUserTrades.length == 0) {
            return null;
        }
        Order.OrderType orderType = null;
        Instrument currencyPair = null;
        BigDecimal amount = new BigDecimal(0);
        ArrayList<BigDecimal> weightedPrices = new ArrayList<BigDecimal>();
        for (PoloniexUserTrade poloniexUserTrade : poloniexUserTrades) {
            orderType = poloniexUserTrade.getType().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
            amount = amount.add(poloniexUserTrade.getAmount());
            weightedPrices.add(poloniexUserTrade.getRate().multiply(poloniexUserTrade.getAmount()));
        }
        BigDecimal weightedAveragePrice = weightedPrices.stream().reduce(new BigDecimal(0), BigDecimal::add).divide(amount, RoundingMode.HALF_UP);
        return new LimitOrder(orderType, null, currencyPair, orderId, null, null, weightedAveragePrice, amount, null, Order.OrderStatus.UNKNOWN);
    }

    public static CandleStickData adaptPoloniexCandleStickData(PoloniexChartData[] poloniexChartData, CurrencyPair currencyPair) {
        CandleStickData candleStickData = null;
        if (poloniexChartData.length != 0) {
            ArrayList<CandleStick> candleSticks = new ArrayList<CandleStick>();
            for (PoloniexChartData chartData : poloniexChartData) {
                candleSticks.add(new CandleStick.Builder().timestamp(chartData.getDate()).open(chartData.getOpen()).high(chartData.getHigh()).low(chartData.getLow()).close(chartData.getClose()).volume(chartData.getVolume()).quotaVolume(chartData.getQuoteVolume()).build());
            }
            candleStickData = new CandleStickData((Instrument)currencyPair, candleSticks);
        }
        return candleStickData;
    }
}

