/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.latoken.LatokenAdapters;
import org.knowm.xchange.latoken.dto.LatokenException;
import org.knowm.xchange.latoken.dto.trade.LatokenCancelledOrders;
import org.knowm.xchange.latoken.dto.trade.LatokenNewOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenOrderSide;
import org.knowm.xchange.latoken.dto.trade.LatokenOrderStatus;
import org.knowm.xchange.latoken.dto.trade.LatokenTestOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenUserTrades;
import org.knowm.xchange.latoken.dto.trade.OrderSubclass;
import org.knowm.xchange.latoken.service.LatokenBaseService;

public class LatokenTradeServiceRaw
extends LatokenBaseService {
    protected LatokenTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<LatokenOrder> getLatokenOpenOrders(CurrencyPair pair, Integer limit) throws LatokenException, IOException {
        return this.latoken.getOpenOrders(LatokenAdapters.toSymbol(pair), System.currentTimeMillis(), limit, this.apiKey, this.signatureCreator);
    }

    public LatokenOrder getLatokenOrder(String orderId) throws LatokenException, IOException {
        return this.latoken.getOrder(orderId, this.apiKey, this.signatureCreator);
    }

    public List<LatokenOrder> getLatokenOrders(CurrencyPair pair, LatokenOrderStatus status, Integer limit) throws LatokenException, IOException {
        return this.latoken.getOrders(LatokenAdapters.toSymbol(pair), status.toString(), limit, this.apiKey, this.signatureCreator);
    }

    public LatokenNewOrder placeLatokenNewOrder(CurrencyPair pair, String clientOrderId, LatokenOrderSide side, BigDecimal price, BigDecimal amount) throws IOException, LatokenException {
        return this.latoken.newOrder(LatokenAdapters.toSymbol(pair), clientOrderId, side, price, amount, OrderSubclass.limit, System.currentTimeMillis(), "", this.apiKey, this.signatureCreator);
    }

    public LatokenTestOrder placeLatokenTestOrder(CurrencyPair pair, String clientOrderId, LatokenOrderSide side, BigDecimal price, BigDecimal amount) throws IOException, LatokenException {
        return this.latoken.testNewOrder(LatokenAdapters.toSymbol(pair), clientOrderId, side, price, amount, OrderSubclass.limit, System.currentTimeMillis(), "", this.apiKey, this.signatureCreator);
    }

    public LatokenOrder cancelLatokenOrder(String orderId) throws IOException, LatokenException {
        return this.latoken.cancelOrder(orderId, System.currentTimeMillis(), "", this.apiKey, this.signatureCreator);
    }

    public LatokenCancelledOrders cancelLatokenOrders(CurrencyPair pair) throws LatokenException, IOException {
        return this.latoken.cancelAll(LatokenAdapters.toSymbol(pair), System.currentTimeMillis(), "", this.apiKey, this.signatureCreator);
    }

    public LatokenUserTrades getLatokenUserTrades(CurrencyPair pair, Integer limit) throws LatokenException, IOException {
        return this.latoken.getUserTrades(LatokenAdapters.toSymbol(pair), System.currentTimeMillis(), limit, this.apiKey, this.signatureCreator);
    }
}

