/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.latoken.LatokenAdapters;
import org.knowm.xchange.latoken.LatokenErrorAdapter;
import org.knowm.xchange.latoken.dto.LatokenException;
import org.knowm.xchange.latoken.dto.trade.LatokenCancelledOrders;
import org.knowm.xchange.latoken.dto.trade.LatokenNewOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenOrderStatus;
import org.knowm.xchange.latoken.dto.trade.LatokenTestOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenUserTrades;
import org.knowm.xchange.latoken.service.LatokenOrderFlags;
import org.knowm.xchange.latoken.service.LatokenQueryOrderParams;
import org.knowm.xchange.latoken.service.LatokenTradeHistoryParams;
import org.knowm.xchange.latoken.service.LatokenTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;

public class LatokenTradeService
extends LatokenTradeServiceRaw
implements TradeService {
    public LatokenTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        try {
            if (!(params instanceof OpenOrdersParamCurrencyPair)) {
                throw new ExchangeException("CurrencyPair is must be provided to get open orders.");
            }
            OpenOrdersParamCurrencyPair pairParams = (OpenOrdersParamCurrencyPair)params;
            CurrencyPair pair = pairParams.getCurrencyPair();
            if (pair == null) {
                throw new ExchangeException("CurrencyPair is must be provided to get open orders.");
            }
            List<LatokenOrder> latokenOpenOrders = this.getLatokenOpenOrders(pair, Integer.MAX_VALUE);
            return LatokenAdapters.adaptOpenOrders(this.exchange, latokenOpenOrders);
        }
        catch (LatokenException e) {
            throw LatokenErrorAdapter.adapt(e);
        }
    }

    public String placeLimitOrder(LimitOrder order) throws IOException {
        LatokenNewOrder newOrder = this.placeLatokenNewOrder(order.getCurrencyPair(), this.getClientOrderId(order), LatokenAdapters.toOrderSide(order.getType()), order.getLimitPrice(), order.getOriginalAmount());
        return newOrder.getOrderId();
    }

    public boolean placeTestOrder(LimitOrder order) throws IOException {
        LatokenTestOrder testOrder = this.placeLatokenTestOrder(order.getCurrencyPair(), this.getClientOrderId(order), LatokenAdapters.toOrderSide(order.getType()), order.getLimitPrice(), order.getOriginalAmount());
        return testOrder.isSuccess();
    }

    private String getClientOrderId(LimitOrder order) {
        String clientOrderId = null;
        for (Order.IOrderFlags flags : order.getOrderFlags()) {
            if (!(flags instanceof LatokenOrderFlags)) continue;
            LatokenOrderFlags of = (LatokenOrderFlags)flags;
            if (clientOrderId != null) continue;
            clientOrderId = of.getClientId();
        }
        return clientOrderId;
    }

    public boolean cancelOrder(String orderId) throws IOException {
        try {
            LatokenOrder canceledOrder = this.cancelLatokenOrder(orderId);
            return canceledOrder.getOrderStatus() != LatokenOrderStatus.active;
        }
        catch (LatokenException e) {
            throw LatokenErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(CancelOrderParams params) throws IOException {
        if (!(params instanceof CancelOrderByIdParams)) {
            throw new ExchangeException("OrderId must be provided to cancel an order.");
        }
        CancelOrderByIdParams paramId = (CancelOrderByIdParams)params;
        String orderId = paramId.getOrderId();
        if (orderId == null) {
            throw new ExchangeException("OrderId must be provided to cancel an order.");
        }
        return this.cancelOrder(orderId);
    }

    public List<String> cancelOrders(CurrencyPair pair) throws IOException {
        try {
            LatokenCancelledOrders canceledOrders = this.cancelLatokenOrders(pair);
            return canceledOrders.getCancelledOrders();
        }
        catch (LatokenException e) {
            throw LatokenErrorAdapter.adapt(e);
        }
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        if (!(params instanceof TradeHistoryParamCurrencyPair)) {
            throw new ExchangeException("CurrencyPair must be provided to get user trades.");
        }
        TradeHistoryParamCurrencyPair pairParams = (TradeHistoryParamCurrencyPair)params;
        CurrencyPair pair = pairParams.getCurrencyPair();
        if (pair == null) {
            throw new ExchangeException("CurrencyPair must be provided to get user trades.");
        }
        Integer limit = null;
        if (params instanceof TradeHistoryParamLimit) {
            TradeHistoryParamLimit limitParams = (TradeHistoryParamLimit)params;
            limit = limitParams.getLimit();
        }
        try {
            LatokenUserTrades latokenTrades = this.getLatokenUserTrades(pair, limit);
            return LatokenAdapters.adaptUserTrades(this.exchange, latokenTrades);
        }
        catch (LatokenException e) {
            throw LatokenErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new LatokenTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public Class getRequiredOrderQueryParamClass() {
        return OrderQueryParamCurrencyPair.class;
    }

    public Collection<Order> getOrder(OrderQueryParams ... params) throws IOException {
        try {
            ArrayList<Order> orders = new ArrayList<Order>();
            for (OrderQueryParams param : params) {
                if (param instanceof OrderQueryParamCurrencyPair) {
                    OrderQueryParamCurrencyPair orderQueryParamCurrencyPair = (OrderQueryParamCurrencyPair)param;
                    CurrencyPair pair = orderQueryParamCurrencyPair.getCurrencyPair();
                    if (pair == null) {
                        throw new ExchangeException("CurrencyPair must be provided to query an order.");
                    }
                    LatokenOrderStatus status = LatokenOrderStatus.active;
                    Integer limit = null;
                    if (param instanceof LatokenQueryOrderParams) {
                        LatokenQueryOrderParams latokenParam = (LatokenQueryOrderParams)param;
                        status = latokenParam.getStatus();
                        limit = latokenParam.getLimit();
                    }
                    List<LatokenOrder> latokenOrders = this.getLatokenOrders(pair, status, limit);
                    latokenOrders.forEach(latokenOrder -> orders.add((Order)LatokenAdapters.adaptOrder(this.exchange, latokenOrder)));
                    continue;
                }
                if (param.getOrderId() == null) {
                    throw new ExchangeException("OrderId must be provided to query an order.");
                }
                LatokenOrder latokenOrder2 = this.getLatokenOrder(param.getOrderId());
                orders.add((Order)LatokenAdapters.adaptOrder(this.exchange, latokenOrder2));
            }
            return orders;
        }
        catch (LatokenException e) {
            throw LatokenErrorAdapter.adapt(e);
        }
    }
}

