/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.latoken.LatokenAdapters;
import org.knowm.xchange.latoken.dto.marketdata.LatokenOrderbook;
import org.knowm.xchange.latoken.dto.marketdata.LatokenTicker;
import org.knowm.xchange.latoken.dto.marketdata.LatokenTrades;
import org.knowm.xchange.latoken.service.LatokenBaseService;

public class LatokenMarketDataServiceRaw
extends LatokenBaseService {
    protected LatokenMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public LatokenTicker getLatokenTicker(CurrencyPair pair) throws IOException {
        LatokenTicker ticker = this.latoken.getTicker(LatokenAdapters.toSymbol(pair));
        return ticker;
    }

    public List<LatokenTicker> getLatokenTickers() throws IOException {
        List<LatokenTicker> latokenTickerList = this.latoken.getAllTickers();
        return latokenTickerList;
    }

    public LatokenOrderbook getLatokenOrderbook(CurrencyPair pair, Integer limit) throws IOException {
        return this.latoken.getOrderbook(LatokenAdapters.toSymbol(pair), limit);
    }

    public LatokenTrades getLatokenTrades(CurrencyPair pair, Integer limit) throws IOException {
        return this.latoken.getTrades(LatokenAdapters.toSymbol(pair), limit);
    }
}

