/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken.service;

import java.io.UnsupportedEncodingException;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import si.mazi.rescu.RestInvocation;

public class LatokenHmacDigest
extends BaseParamsDigest {
    private LatokenHmacDigest(String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA256");
    }

    public static LatokenHmacDigest createInstance(String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new LatokenHmacDigest(secretKeyBase64);
    }

    public String digestParams(RestInvocation restInvocation) {
        try {
            String path = restInvocation.getPath();
            String queryParameters = restInvocation.getQueryString();
            String toSign = "/" + path + "?" + queryParameters;
            Mac mac = this.getMac();
            mac.update(toSign.getBytes("UTF-8"));
            return DigestUtils.bytesToHex((byte[])mac.doFinal());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("This JVM does not support HMAC_SHA_256?", e);
        }
    }
}

