/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken;

import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.ExchangeSecurityException;
import org.knowm.xchange.exceptions.RateLimitExceededException;
import org.knowm.xchange.latoken.dto.LatokenException;

public final class LatokenErrorAdapter {
    private LatokenErrorAdapter() {
    }

    public static ExchangeException adapt(LatokenException e) {
        String message = e.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = "Operation failed without any error message";
        }
        switch (e.getHttpStatusCode()) {
            case 400: {
                return new ExchangeException(message, (Throwable)((Object)e));
            }
            case 401: {
                return new ExchangeSecurityException(message, (Throwable)((Object)e));
            }
            case 428: {
                return new RateLimitExceededException(message, (Throwable)((Object)e));
            }
        }
        return new ExchangeException(message, (Throwable)((Object)e));
    }
}

