/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.latoken.Latoken;
import org.knowm.xchange.latoken.dto.LatokenException;
import org.knowm.xchange.latoken.dto.account.LatokenBalance;
import org.knowm.xchange.latoken.dto.trade.LatokenCancelledOrders;
import org.knowm.xchange.latoken.dto.trade.LatokenNewOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenOrderSide;
import org.knowm.xchange.latoken.dto.trade.LatokenTestOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenUserTrades;
import org.knowm.xchange.latoken.dto.trade.OrderSubclass;
import si.mazi.rescu.ParamsDigest;

@Path(value="")
@Produces(value={"application/json"})
public interface LatokenAuthenticated
extends Latoken {
    public static final String API_KEY = "X-LA-KEY";
    public static final String SIGNATURE = "X-LA-SIGNATURE";
    public static final String HASHTYPE = "X-LA-HASHTYPE";

    @POST
    @Path(value="api/v1/Order/new")
    public LatokenNewOrder newOrder(@QueryParam(value="symbol") String var1, @QueryParam(value="cliOrdId") String var2, @QueryParam(value="side") LatokenOrderSide var3, @QueryParam(value="price") BigDecimal var4, @QueryParam(value="amount") BigDecimal var5, @QueryParam(value="orderType") OrderSubclass var6, @QueryParam(value="timestamp") long var7, @FormParam(value="dummy") String var9, @HeaderParam(value="X-LA-KEY") String var10, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var11) throws IOException, LatokenException;

    @POST
    @Path(value="api/v1/Order/test-order")
    public LatokenTestOrder testNewOrder(@QueryParam(value="symbol") String var1, @QueryParam(value="cliOrdId") String var2, @QueryParam(value="side") LatokenOrderSide var3, @QueryParam(value="price") BigDecimal var4, @QueryParam(value="amount") BigDecimal var5, @QueryParam(value="orderType") OrderSubclass var6, @QueryParam(value="timestamp") long var7, @FormParam(value="dummy") String var9, @HeaderParam(value="X-LA-KEY") String var10, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var11) throws IOException, LatokenException;

    @POST
    @Path(value="api/v1/Order/cancel")
    public LatokenOrder cancelOrder(@QueryParam(value="orderId") String var1, @QueryParam(value="timestamp") long var2, @FormParam(value="dummy") String var4, @HeaderParam(value="X-LA-KEY") String var5, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var6) throws IOException, LatokenException;

    @POST
    @Path(value="api/v1/Order/cancel_all")
    public LatokenCancelledOrders cancelAll(@QueryParam(value="symbol") String var1, @QueryParam(value="timestamp") long var2, @FormParam(value="dummy") String var4, @HeaderParam(value="X-LA-KEY") String var5, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var6) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/Order/get_order")
    public LatokenOrder getOrder(@QueryParam(value="orderId") String var1, @HeaderParam(value="X-LA-KEY") String var2, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var3) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/Order/status")
    public List<LatokenOrder> getOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="status") String var2, @QueryParam(value="limit") int var3, @HeaderParam(value="X-LA-KEY") String var4, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var5) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/Order/active")
    public List<LatokenOrder> getOpenOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="timestamp") long var2, @QueryParam(value="limit") int var4, @HeaderParam(value="X-LA-KEY") String var5, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var6) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/Order/trades")
    public LatokenUserTrades getUserTrades(@QueryParam(value="symbol") String var1, @QueryParam(value="timestamp") long var2, @QueryParam(value="limit") int var4, @HeaderParam(value="X-LA-KEY") String var5, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var6) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/Account/balances")
    public List<LatokenBalance> getBalances(@QueryParam(value="timestamp") Long var1, @HeaderParam(value="X-LA-KEY") String var2, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var3) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/Account/balances/{currency}")
    public LatokenBalance getBalance(@PathParam(value="currency") String var1, @QueryParam(value="timestamp") Long var2, @HeaderParam(value="X-LA-KEY") String var3, @HeaderParam(value="X-LA-SIGNATURE") ParamsDigest var4) throws IOException, LatokenException;
}

