/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.latoken.dto.account.LatokenBalance;
import org.knowm.xchange.latoken.dto.exchangeinfo.LatokenCurrency;
import org.knowm.xchange.latoken.dto.exchangeinfo.LatokenPair;
import org.knowm.xchange.latoken.dto.marketdata.LatokenOrderbook;
import org.knowm.xchange.latoken.dto.marketdata.LatokenTicker;
import org.knowm.xchange.latoken.dto.marketdata.LatokenTrade;
import org.knowm.xchange.latoken.dto.marketdata.LatokenTrades;
import org.knowm.xchange.latoken.dto.trade.LatokenOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenOrderSide;
import org.knowm.xchange.latoken.dto.trade.LatokenOrderStatus;
import org.knowm.xchange.latoken.dto.trade.LatokenUserTrade;
import org.knowm.xchange.latoken.dto.trade.LatokenUserTrades;

public class LatokenAdapters {
    public static Currency adaptCurrency(LatokenCurrency latokenCurrency) {
        return Currency.getInstance((String)latokenCurrency.getSymbol());
    }

    public static CurrencyPair adaptCurrencyPair(LatokenPair latokenPair) {
        Currency base = Currency.getInstance((String)latokenPair.getBaseCurrency());
        Currency counter = Currency.getInstance((String)latokenPair.getCounterCurrency());
        return new CurrencyPair(base, counter);
    }

    public static InstrumentMetaData adaptPairMetaData(LatokenPair latokenPair) {
        BigDecimal tradingFee = latokenPair.getTakerFee();
        BigDecimal minAmount = latokenPair.getMinOrderAmount().setScale(latokenPair.getAmountPrecision(), RoundingMode.HALF_DOWN);
        int priceScale = latokenPair.getPricePrecision();
        return new InstrumentMetaData.Builder().tradingFee(tradingFee).minimumAmount(minAmount).priceScale(Integer.valueOf(priceScale)).build();
    }

    public static CurrencyPair adaptCurrencyPair(Exchange exchange, String latokenSymbol) {
        Object pairs = exchange.getExchangeSpecification().getExchangeSpecificParametersItem("pairs");
        List allPairs = (List)pairs;
        if (allPairs == null) {
            throw new ExchangeException("'pairs' parameter must be set on exchange specifications");
        }
        Optional<LatokenPair> oPair = allPairs.stream().filter(pair -> pair.getSymbol().equals(latokenSymbol)).findAny();
        return oPair.isPresent() ? LatokenAdapters.adaptCurrencyPair(oPair.get()) : null;
    }

    public static Balance adaptBalance(LatokenBalance latokenBalance) {
        return new Balance(Currency.getInstance((String)latokenBalance.getSymbol()), latokenBalance.getAmount(), latokenBalance.getAvailable(), latokenBalance.getFrozen(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, latokenBalance.getPending());
    }

    public static Ticker adaptTicker(LatokenTicker latokenTicker) {
        return new Ticker.Builder().open(latokenTicker.getOpen()).last(latokenTicker.getClose()).low(latokenTicker.getLow()).high(latokenTicker.getHigh()).volume(latokenTicker.getVolume()).build();
    }

    public static OrderBook adaptOrderBook(Exchange exchange, LatokenOrderbook latokenOrderbook) {
        CurrencyPair pair = LatokenAdapters.adaptCurrencyPair(exchange, latokenOrderbook.getSymbol());
        List asks = latokenOrderbook.getAsks().stream().map(level -> new LimitOrder.Builder(Order.OrderType.ASK, (Instrument)pair).originalAmount(level.getAmount()).limitPrice(level.getPrice()).build()).collect(Collectors.toList());
        List bids = latokenOrderbook.getBids().stream().map(level -> new LimitOrder.Builder(Order.OrderType.BID, (Instrument)pair).originalAmount(level.getAmount()).limitPrice(level.getPrice()).build()).collect(Collectors.toList());
        return new OrderBook(null, asks, bids);
    }

    public static Trades adaptTrades(Exchange exchange, LatokenTrades latokenTrades) {
        CurrencyPair pair = LatokenAdapters.adaptCurrencyPair(exchange, latokenTrades.getSymbol());
        List trades = latokenTrades.getTrades().stream().map(latokenTrade -> LatokenAdapters.adaptTrade(latokenTrade, pair)).collect(Collectors.toList());
        return new Trades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static Trade adaptTrade(LatokenTrade latokenTrade, CurrencyPair pair) {
        return new Trade.Builder().type(LatokenAdapters.adaptOrderType(latokenTrade.getSide())).currencyPair(pair).originalAmount(latokenTrade.getAmount()).price(latokenTrade.getPrice()).timestamp(latokenTrade.getTimestamp()).build();
    }

    public static LimitOrder adaptOrder(Exchange exchange, LatokenOrder order) {
        Order.OrderType type = LatokenAdapters.adaptOrderType(order.getSide());
        CurrencyPair currencyPair = LatokenAdapters.adaptCurrencyPair(exchange, order.getSymbol());
        Order.OrderStatus orderStatus = LatokenAdapters.adaptOrderStatus(order.getOrderStatus());
        return new LimitOrder.Builder(type, (Instrument)currencyPair).originalAmount(order.getAmount()).id(order.getOrderId()).timestamp(order.getTimeCreated()).limitPrice(order.getPrice()).cumulativeAmount(order.getExecutedAmount()).fee(BigDecimal.ZERO).orderStatus(orderStatus).build();
    }

    public static OpenOrders adaptOpenOrders(Exchange exchange, List<LatokenOrder> latokenOpenOrders) {
        List openOrders = latokenOpenOrders.stream().map(latokenOrder -> LatokenAdapters.adaptOrder(exchange, latokenOrder)).collect(Collectors.toList());
        return new OpenOrders(openOrders);
    }

    public static Order.OrderType adaptOrderType(LatokenOrderSide side) {
        switch (side) {
            case buy: {
                return Order.OrderType.BID;
            }
            case sell: {
                return Order.OrderType.ASK;
            }
        }
        throw new RuntimeException("Not supported order side: " + (Object)((Object)side));
    }

    public static Order.OrderStatus adaptOrderStatus(LatokenOrderStatus latokenOrderStatus) {
        switch (latokenOrderStatus) {
            case active: {
                return Order.OrderStatus.NEW;
            }
            case partiallyFilled: {
                return Order.OrderStatus.PARTIALLY_FILLED;
            }
            case filled: {
                return Order.OrderStatus.FILLED;
            }
            case cancelled: {
                return Order.OrderStatus.CANCELED;
            }
        }
        return Order.OrderStatus.UNKNOWN;
    }

    public static UserTrades adaptUserTrades(Exchange exchange, LatokenUserTrades latokenUserTrades) {
        CurrencyPair pair = LatokenAdapters.adaptCurrencyPair(exchange, latokenUserTrades.getSymbol());
        List trades = latokenUserTrades.getTrades().stream().map(latokenUserTrade -> LatokenAdapters.adaptUserTrade(latokenUserTrade, pair)).collect(Collectors.toList());
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static UserTrade adaptUserTrade(LatokenUserTrade latokenUserTrade, CurrencyPair pair) {
        return UserTrade.builder().type(LatokenAdapters.adaptOrderType(latokenUserTrade.getSide())).originalAmount(latokenUserTrade.getAmount()).currencyPair(pair).price(latokenUserTrade.getPrice()).timestamp(latokenUserTrade.getTime()).id(latokenUserTrade.getId()).orderId(latokenUserTrade.getOrderId()).feeAmount(latokenUserTrade.getFee()).feeCurrency(pair.counter).build();
    }

    public static String toSymbol(CurrencyPair pair) {
        return pair.base.getCurrencyCode() + pair.counter.getCurrencyCode();
    }

    public static String toSymbol(Currency currency) {
        return currency.getSymbol();
    }

    public static LatokenOrderSide toOrderSide(Order.OrderType type) {
        switch (type) {
            case ASK: {
                return LatokenOrderSide.sell;
            }
            case BID: {
                return LatokenOrderSide.buy;
            }
        }
        throw new RuntimeException("Not supported order type: " + type);
    }

    public static LatokenOrderStatus toLatokenOrderStatus(Order.OrderStatus status) {
        switch (status) {
            case PENDING_NEW: 
            case NEW: 
            case PENDING_CANCEL: 
            case PENDING_REPLACE: {
                return LatokenOrderStatus.active;
            }
            case PARTIALLY_FILLED: {
                return LatokenOrderStatus.partiallyFilled;
            }
            case FILLED: {
                return LatokenOrderStatus.filled;
            }
            case CANCELED: 
            case STOPPED: 
            case EXPIRED: 
            case REJECTED: 
            case REPLACED: {
                return LatokenOrderStatus.cancelled;
            }
        }
        throw new RuntimeException("Not supported order status: " + status);
    }
}

