/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.List;
import org.knowm.xchange.latoken.dto.LatokenException;
import org.knowm.xchange.latoken.dto.exchangeinfo.LatokenCurrency;
import org.knowm.xchange.latoken.dto.exchangeinfo.LatokenPair;
import org.knowm.xchange.latoken.dto.exchangeinfo.LatokenRateLimits;
import org.knowm.xchange.latoken.dto.exchangeinfo.LatokenTime;
import org.knowm.xchange.latoken.dto.marketdata.LatokenOrderbook;
import org.knowm.xchange.latoken.dto.marketdata.LatokenTicker;
import org.knowm.xchange.latoken.dto.marketdata.LatokenTrades;

@Path(value="")
@Produces(value={"application/json"})
public interface Latoken {
    @GET
    @Path(value="api/v1/ExchangeInfo/time")
    public LatokenTime getTime() throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/ExchangeInfo/limits")
    public LatokenRateLimits getRateLimits() throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/ExchangeInfo/pairs")
    public List<LatokenPair> getAllPairs() throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/ExchangeInfo/pairs/{currency}")
    public List<LatokenPair> getPairs(@PathParam(value="currency") String var1) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/ExchangeInfo/pair")
    public LatokenPair getPair(@QueryParam(value="symbol") String var1) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/ExchangeInfo/currencies")
    public List<LatokenCurrency> getAllCurrencies() throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/ExchangeInfo/currencies/{symbol}")
    public LatokenCurrency getCurrencies(@PathParam(value="symbol") String var1) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/MarketData/tickers")
    public List<LatokenTicker> getAllTickers() throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/MarketData/ticker/{symbol}")
    public LatokenTicker getTicker(@PathParam(value="symbol") String var1) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/MarketData/orderBook/{symbol}/{limit}")
    public LatokenOrderbook getOrderbook(@PathParam(value="symbol") String var1, @PathParam(value="limit") int var2) throws IOException, LatokenException;

    @GET
    @Path(value="api/v1/MarketData/trades/{symbol}/{limit}")
    public LatokenTrades getTrades(@PathParam(value="symbol") String var1, @PathParam(value="limit") int var2) throws IOException, LatokenException;
}

