/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.krakenfutures.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.krakenfutures.KrakenFuturesAdapters;
import org.knowm.xchange.krakenfutures.dto.marketData.KrakenFuturesOrder;
import org.knowm.xchange.krakenfutures.dto.trade.BatchOrder;
import org.knowm.xchange.krakenfutures.dto.trade.BatchOrderResult;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesCancel;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesCancelAllOrders;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesCancelAllOrdersAfter;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesEditOrderResponse;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesFills;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOpenOrders;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrderFlags;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrderSide;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrderStatusRequest;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrderType;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrdersStatusesResponse;
import org.knowm.xchange.krakenfutures.dto.trade.OrderCommand;
import org.knowm.xchange.krakenfutures.service.KrakenFuturesBaseService;
import org.knowm.xchange.utils.DateUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class KrakenFuturesTradeServiceRaw
extends KrakenFuturesBaseService {
    public KrakenFuturesTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public KrakenFuturesOrder placeKrakenFuturesLimitOrder(LimitOrder order) throws IOException {
        KrakenFuturesOrder ord = this.krakenFuturesAuthenticated.sendOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), order.hasFlag((Order.IOrderFlags)KrakenFuturesOrderFlags.POST_ONLY) ? KrakenFuturesOrderType.post.name() : KrakenFuturesOrderType.lmt.name(), KrakenFuturesAdapters.adaptKrakenFuturesSymbol(order.getInstrument()), order.getType().equals((Object)Order.OrderType.ASK) ? KrakenFuturesOrderSide.sell.name() : KrakenFuturesOrderSide.buy.name(), order.getOriginalAmount(), order.getLimitPrice(), order.getUserReference(), order.hasFlag((Order.IOrderFlags)KrakenFuturesOrderFlags.REDUCE_ONLY), null, null);
        if (ord.isSuccess() && ord.getOrderStatus().getStatus().equals("placed")) {
            return ord;
        }
        String errorMessage = ord.getError() == null ? ord.getOrderStatus().getStatus() : ord.getError();
        throw new ExchangeException("Error sending CF limit order: " + errorMessage);
    }

    public KrakenFuturesOrder placeKrakenFuturesMarketOrder(MarketOrder order) throws IOException {
        KrakenFuturesOrder ord = this.krakenFuturesAuthenticated.sendOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), KrakenFuturesOrderType.mkt.name(), KrakenFuturesAdapters.adaptKrakenFuturesSymbol(order.getInstrument()), order.getType().equals((Object)Order.OrderType.ASK) ? KrakenFuturesOrderSide.sell.name() : KrakenFuturesOrderSide.buy.name(), order.getOriginalAmount(), null, order.getUserReference(), order.hasFlag((Order.IOrderFlags)KrakenFuturesOrderFlags.REDUCE_ONLY), null, null);
        if (ord.isSuccess() && ord.getOrderStatus().getStatus().equals("placed")) {
            return ord;
        }
        String errorMessage = ord.getError() == null ? ord.getOrderStatus().getStatus() : ord.getError();
        throw new ExchangeException("Error sending CF limit order: " + errorMessage);
    }

    public KrakenFuturesOrder placeKrakenFuturesStopOrder(StopOrder order) throws IOException {
        KrakenFuturesOrder ord = this.krakenFuturesAuthenticated.sendOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), order.getIntention().equals((Object)StopOrder.Intention.STOP_LOSS) ? KrakenFuturesOrderType.stp.name() : KrakenFuturesOrderType.take_profit.name(), KrakenFuturesAdapters.adaptKrakenFuturesSymbol(order.getInstrument()), order.getType().equals((Object)Order.OrderType.ASK) ? KrakenFuturesOrderSide.sell.name() : KrakenFuturesOrderSide.buy.name(), order.getOriginalAmount(), order.getLimitPrice() != null ? order.getLimitPrice() : null, order.getUserReference(), order.hasFlag((Order.IOrderFlags)KrakenFuturesOrderFlags.REDUCE_ONLY), order.getStopPrice(), "mark");
        if (ord.isSuccess() && ord.getOrderStatus().getStatus().equals("placed")) {
            return ord;
        }
        String errorMessage = ord.getError() == null ? ord.getOrderStatus().getStatus() : ord.getError();
        throw new ExchangeException("Error sending CF limit order: " + errorMessage);
    }

    public String changeKrakenFuturesOrder(LimitOrder limitOrder) throws IOException {
        KrakenFuturesEditOrderResponse ord = this.krakenFuturesAuthenticated.changeOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), limitOrder.getUserReference(), limitOrder.getLimitPrice(), limitOrder.getUserReference() != null ? limitOrder.getId() : null, limitOrder.getOriginalAmount(), null);
        if (ord.isSuccess()) {
            return ord.getEditStatus().getOrderId();
        }
        throw new ExchangeException("Error sending CF limit order: " + ord.getError());
    }

    public BatchOrderResult sendKrakenFuturesBatchOrder(List<OrderCommand> commands) throws IOException {
        BatchOrderResult ord = this.krakenFuturesAuthenticated.batchOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new BatchOrder(commands));
        if (ord.isSuccess()) {
            return ord;
        }
        throw new ExchangeException("Error sending CF batch order: " + ord.getError());
    }

    public KrakenFuturesCancel cancelKrakenFuturesOrder(String uid) throws IOException {
        KrakenFuturesCancel res = this.krakenFuturesAuthenticated.cancelOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), uid);
        if (res.isSuccess()) {
            return res;
        }
        throw new ExchangeException("Error cancelling CF order: " + res.getError());
    }

    public KrakenFuturesOpenOrders getKrakenFuturesOpenOrders() throws IOException {
        KrakenFuturesOpenOrders openOrders = this.krakenFuturesAuthenticated.openOrders(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (openOrders.isSuccess()) {
            return openOrders;
        }
        throw new ExchangeException("Error getting CF open orders: " + openOrders.getError());
    }

    public KrakenFuturesFills getKrakenFuturesFills() throws IOException {
        return this.getKrakenFuturesFills(null);
    }

    public KrakenFuturesFills getKrakenFuturesFills(Date lastFillTime) throws IOException {
        KrakenFuturesFills fills = this.krakenFuturesAuthenticated.fills(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), lastFillTime != null ? DateUtils.toUTCISODateString((Date)lastFillTime) : null);
        if (fills.isSuccess()) {
            return fills;
        }
        throw new ExchangeException("Error getting CF fills: " + fills.getError());
    }

    public KrakenFuturesCancelAllOrdersAfter cancelAllOrdersAfter(long timeoutSeconds) throws IOException {
        KrakenFuturesCancelAllOrdersAfter cancelallordersafter = this.krakenFuturesAuthenticated.cancelAllOrdersAfter(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), timeoutSeconds);
        if (cancelallordersafter.isSuccess()) {
            return cancelallordersafter;
        }
        throw new ExchangeException("Error cancelling all CF orders after: " + cancelallordersafter.getError());
    }

    public KrakenFuturesCancelAllOrders cancelAllOrdersByInstrument(Instrument instrument) throws IOException {
        KrakenFuturesCancelAllOrders cancelAllOrdersByInstrument = this.krakenFuturesAuthenticated.cancelAllOrdersByInstrument(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), KrakenFuturesAdapters.adaptKrakenFuturesSymbol(instrument));
        if (cancelAllOrdersByInstrument.isSuccess()) {
            return cancelAllOrdersByInstrument;
        }
        throw new ExchangeException("Error cancelling all CF orders after: " + cancelAllOrdersByInstrument.getError());
    }

    public KrakenFuturesOrdersStatusesResponse getKrakenFuturesOrdersStatuses(String ... orderIds) throws IOException {
        KrakenFuturesOrdersStatusesResponse cancelAllOrdersByInstrument = this.krakenFuturesAuthenticated.getOrdersStatuses(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new KrakenFuturesOrderStatusRequest(orderIds));
        if (cancelAllOrdersByInstrument.isSuccess()) {
            return cancelAllOrdersByInstrument;
        }
        throw new ExchangeException("Error cancelling all CF orders after: " + cancelAllOrdersByInstrument.getError());
    }
}

