/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.krakenfutures.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.krakenfutures.KrakenFuturesAuthenticated;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOpenPositions;
import org.knowm.xchange.krakenfutures.service.KrakenFuturesDigest;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class KrakenFuturesBaseService
extends BaseExchangeService
implements BaseService {
    protected KrakenFuturesAuthenticated krakenFuturesAuthenticated;
    protected ParamsDigest signatureCreator;

    public KrakenFuturesBaseService(Exchange exchange) {
        super(exchange);
        this.krakenFuturesAuthenticated = (KrakenFuturesAuthenticated)ExchangeRestProxyBuilder.forInterface(KrakenFuturesAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.signatureCreator = KrakenFuturesDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public KrakenFuturesOpenPositions getKrakenFuturesOpenPositions() throws IOException {
        KrakenFuturesOpenPositions openPositions = this.krakenFuturesAuthenticated.openPositions(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (openPositions.isSuccess()) {
            return openPositions;
        }
        throw new ExchangeException("Error getting CF open positions: " + openPositions.getError());
    }
}

