/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.krakenfutures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.OpenPosition;
import org.knowm.xchange.dto.account.OpenPositions;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.FundingRate;
import org.knowm.xchange.dto.marketdata.FundingRates;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.krakenfutures.dto.account.KrakenFuturesAccountInfo;
import org.knowm.xchange.krakenfutures.dto.account.KrakenFuturesAccounts;
import org.knowm.xchange.krakenfutures.dto.marketData.KrakenFuturesInstrument;
import org.knowm.xchange.krakenfutures.dto.marketData.KrakenFuturesInstruments;
import org.knowm.xchange.krakenfutures.dto.marketData.KrakenFuturesOrderBook;
import org.knowm.xchange.krakenfutures.dto.marketData.KrakenFuturesPublicFill;
import org.knowm.xchange.krakenfutures.dto.marketData.KrakenFuturesPublicFills;
import org.knowm.xchange.krakenfutures.dto.marketData.KrakenFuturesTicker;
import org.knowm.xchange.krakenfutures.dto.marketData.KrakenFuturesTickers;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesFill;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesFills;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOpenOrder;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOpenOrders;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOpenPosition;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOpenPositions;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrderFlags;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrderSide;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrderStatus;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrderType;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesOrdersStatusesResponse;

public class KrakenFuturesAdapters {
    private static final String MULTI_COLLATERAL_PRODUCTS = "PF_";
    private static final String ACCOUNT_TYPE = "multiCollateralMarginAccount";

    public static Ticker adaptTicker(KrakenFuturesTicker krakenFuturesTicker, Instrument instrument) {
        if (krakenFuturesTicker != null) {
            Ticker.Builder builder = new Ticker.Builder();
            builder.ask(krakenFuturesTicker.getAsk());
            builder.bid(krakenFuturesTicker.getBid());
            builder.last(krakenFuturesTicker.getLast());
            builder.instrument(instrument);
            builder.low(krakenFuturesTicker.getLow24H());
            builder.high(krakenFuturesTicker.getHigh24H());
            builder.volume(krakenFuturesTicker.getVol24H());
            builder.quoteVolume(krakenFuturesTicker.getVol24H().multiply(krakenFuturesTicker.getLast()));
            builder.timestamp(krakenFuturesTicker.getLastTime());
            return builder.build();
        }
        return null;
    }

    public static AccountInfo adaptAccounts(KrakenFuturesAccounts krakenFuturesAccounts, KrakenFuturesOpenPositions krakenFuturesOpenPositions) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        BigDecimal collateralValue = BigDecimal.ZERO;
        for (Map.Entry<String, KrakenFuturesAccountInfo> krakenFuturesAccountInfo : krakenFuturesAccounts.getAccounts().entrySet()) {
            if (!krakenFuturesAccountInfo.getValue().getType().equals(ACCOUNT_TYPE)) continue;
            for (Map.Entry<String, KrakenFuturesAccountInfo.KrakenFuturesCurrency> krakenFuturesCurrencyEntry : krakenFuturesAccountInfo.getValue().getCurrencies().entrySet()) {
                balances.add(new Balance.Builder().currency(new Currency(krakenFuturesCurrencyEntry.getKey())).total(krakenFuturesCurrencyEntry.getValue().getAvailable()).build());
            }
            collateralValue = krakenFuturesAccountInfo.getValue().getCollateralValue();
        }
        BigDecimal totalOpenPositionsUsdValue = BigDecimal.ZERO;
        for (KrakenFuturesOpenPosition openPosition : krakenFuturesOpenPositions.getOpenPositions()) {
            totalOpenPositionsUsdValue = totalOpenPositionsUsdValue.add(openPosition.getPrice().multiply(openPosition.getSize()));
        }
        return new AccountInfo(ACCOUNT_TYPE, new Wallet[]{new Wallet.Builder().features(Collections.singleton(Wallet.WalletFeature.FUTURES_TRADING)).balances(balances).currentLeverage(totalOpenPositionsUsdValue.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalOpenPositionsUsdValue.divide(collateralValue, 3, RoundingMode.HALF_EVEN)).build()});
    }

    public static Order.OrderType adaptOrderType(KrakenFuturesOrderSide krakenFuturesOrderType) {
        return krakenFuturesOrderType.equals((Object)KrakenFuturesOrderSide.buy) ? Order.OrderType.BID : Order.OrderType.ASK;
    }

    public static LimitOrder adaptLimitOrder(KrakenFuturesOpenOrder ord) {
        return new LimitOrder.Builder(KrakenFuturesAdapters.adaptOrderType(ord.getSide()), KrakenFuturesAdapters.adaptInstrument(ord.getSymbol())).originalAmount(ord.getFilledSize().add(ord.getUnfilledSize())).id(ord.getOrderId()).timestamp(ord.getReceivedTime()).limitPrice(ord.getLimitPrice()).orderStatus(KrakenFuturesAdapters.adaptOrderStatus(ord.getStatus())).remainingAmount(ord.getUnfilledSize()).flag((Order.IOrderFlags)(ord.isReduceOnly() ? KrakenFuturesOrderFlags.REDUCE_ONLY : null)).build();
    }

    public static StopOrder adaptStopOrder(KrakenFuturesOpenOrder ord) {
        return new StopOrder.Builder(KrakenFuturesAdapters.adaptOrderType(ord.getSide()), KrakenFuturesAdapters.adaptInstrument(ord.getSymbol())).originalAmount(ord.getFilledSize().add(ord.getUnfilledSize())).id(ord.getOrderId()).timestamp(ord.getReceivedTime()).limitPrice(ord.getLimitPrice()).intention(ord.getOrderType().equals((Object)KrakenFuturesOrderType.take_profit) ? StopOrder.Intention.TAKE_PROFIT : StopOrder.Intention.STOP_LOSS).orderStatus(KrakenFuturesAdapters.adaptOrderStatus(ord.getStatus())).remainingAmount(ord.getUnfilledSize()).stopPrice(ord.getStopPrice()).flag((Order.IOrderFlags)(ord.isReduceOnly() ? KrakenFuturesOrderFlags.REDUCE_ONLY : null)).build();
    }

    public static OpenOrders adaptOpenOrders(KrakenFuturesOpenOrders orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        ArrayList<StopOrder> triggerOrders = new ArrayList<StopOrder>();
        if (orders != null && orders.isSuccess()) {
            for (KrakenFuturesOpenOrder ord : orders.getOrders()) {
                if (ord.getOrderType().equals((Object)KrakenFuturesOrderType.lmt)) {
                    limitOrders.add(KrakenFuturesAdapters.adaptLimitOrder(ord));
                    continue;
                }
                if (!ord.getOrderType().equals((Object)KrakenFuturesOrderType.stop) && !ord.getOrderType().equals((Object)KrakenFuturesOrderType.take_profit)) continue;
                triggerOrders.add(KrakenFuturesAdapters.adaptStopOrder(ord));
            }
        }
        return new OpenOrders(limitOrders, triggerOrders);
    }

    public static UserTrade adaptFill(KrakenFuturesFill fill) {
        return UserTrade.builder().type(KrakenFuturesAdapters.adaptOrderType(fill.getSide())).originalAmount(fill.getSize()).instrument(KrakenFuturesAdapters.adaptInstrument(fill.getSymbol())).price(fill.getPrice()).timestamp(fill.getFillTime()).id(fill.getFillId()).orderId(fill.getOrderId()).build();
    }

    public static UserTrades adaptFills(KrakenFuturesFills krakenFuturesFills) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        if (krakenFuturesFills != null && krakenFuturesFills.isSuccess()) {
            for (KrakenFuturesFill fill : krakenFuturesFills.getFills()) {
                trades.add(KrakenFuturesAdapters.adaptFill(fill));
            }
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static OrderBook adaptOrderBook(KrakenFuturesOrderBook krakenFuturesOrderBook) {
        ArrayList asks = new ArrayList();
        ArrayList bids = new ArrayList();
        krakenFuturesOrderBook.getBidsAsks().getAsks().forEach(order -> asks.add(new LimitOrder.Builder(Order.OrderType.ASK, krakenFuturesOrderBook.getInstrument()).limitPrice((BigDecimal)order.get(0)).originalAmount((BigDecimal)order.get(1)).build()));
        krakenFuturesOrderBook.getBidsAsks().getBids().forEach(order -> bids.add(new LimitOrder.Builder(Order.OrderType.BID, krakenFuturesOrderBook.getInstrument()).limitPrice((BigDecimal)order.get(0)).originalAmount((BigDecimal)order.get(1)).build()));
        return new OrderBook(krakenFuturesOrderBook.getServerTime(), asks, bids);
    }

    public static ExchangeMetaData adaptInstrumentsMetaData(KrakenFuturesInstruments krakenFuturesInstruments) {
        HashMap<Instrument, InstrumentMetaData> instruments = new HashMap<Instrument, InstrumentMetaData>();
        HashMap currencies = new HashMap();
        for (KrakenFuturesInstrument instrument : krakenFuturesInstruments.getInstruments()) {
            if (!instrument.getSymbol().contains(MULTI_COLLATERAL_PRODUCTS)) continue;
            instruments.put(KrakenFuturesAdapters.adaptInstrument(instrument.getSymbol()), new InstrumentMetaData.Builder().volumeScale(instrument.getVolumeScale()).priceScale(Integer.valueOf(instrument.getTickSize().scale())).priceStepSize(instrument.getTickSize()).minimumAmount(KrakenFuturesAdapters.getMinimumAmountFromVolumeScale(instrument.getVolumeScale())).build());
        }
        return new ExchangeMetaData(instruments, currencies, null, null, Boolean.valueOf(true));
    }

    public static Instrument adaptInstrument(String symbol) {
        String main_symbol = symbol.replace(MULTI_COLLATERAL_PRODUCTS, "");
        return new FuturesContract(new CurrencyPair(main_symbol.substring(0, main_symbol.length() - 3).replace("XBT", "BTC") + "/" + main_symbol.substring(main_symbol.length() - 3)), "PERP");
    }

    private static BigDecimal getMinimumAmountFromVolumeScale(Integer volumeScale) {
        if (volumeScale == 0) {
            return BigDecimal.ONE;
        }
        StringBuilder sb = new StringBuilder("0.");
        for (int i = 1; i < volumeScale; ++i) {
            sb.append("0");
        }
        sb.append("1");
        return new BigDecimal(sb.toString());
    }

    public static String adaptKrakenFuturesSymbol(Instrument instrument) {
        return MULTI_COLLATERAL_PRODUCTS + instrument.getBase().toString().replace("BTC", "XBT") + instrument.getCounter().toString();
    }

    public static Trades adaptTrades(KrakenFuturesPublicFills krakenFuturesTrades, Instrument instrument) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        for (KrakenFuturesPublicFill fill : krakenFuturesTrades.getFills()) {
            trades.add(new Trade.Builder().id(fill.getTradeId()).type(KrakenFuturesAdapters.adaptOrderType(fill.getSide())).price(fill.getPrice()).originalAmount(fill.getSize()).timestamp(fill.getTime()).instrument(instrument).build());
        }
        return new Trades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static FundingRates adaptFundingRates(KrakenFuturesTickers krakenFuturesTickers) {
        ArrayList<FundingRate> fundingRates = new ArrayList<FundingRate>();
        for (KrakenFuturesTicker ticker : krakenFuturesTickers.getTickers()) {
            if (!ticker.getSymbol().contains(MULTI_COLLATERAL_PRODUCTS)) continue;
            fundingRates.add(KrakenFuturesAdapters.adaptFundingRate(ticker));
        }
        return new FundingRates(fundingRates);
    }

    public static FundingRate adaptFundingRate(KrakenFuturesTicker krakenFuturesTicker) {
        LocalDateTime now = LocalDateTime.now();
        BigDecimal relative1hFundingRate = krakenFuturesTicker.getAbsoluteFundingRate().divide(krakenFuturesTicker.getMarkPrice(), 8, RoundingMode.HALF_EVEN);
        return new FundingRate.Builder().fundingRate1h(relative1hFundingRate).fundingRate8h(relative1hFundingRate.multiply(BigDecimal.valueOf(8L))).fundingRateDate(Date.from(now.plus(60 - now.get(ChronoField.MINUTE_OF_HOUR), ChronoUnit.MINUTES).toInstant(ZoneOffset.UTC))).fundingRateEffectiveInMinutes((long)(60 - LocalTime.now().getMinute())).instrument(KrakenFuturesAdapters.adaptInstrument(krakenFuturesTicker.getSymbol())).build();
    }

    public static Order adaptKrakenFuturesOrder(KrakenFuturesOrdersStatusesResponse.KrakenFuturesOrder krakenFuturesOrder) {
        return new LimitOrder.Builder(KrakenFuturesAdapters.adaptOrderType(krakenFuturesOrder.getOrder().getSide()), KrakenFuturesAdapters.adaptInstrument(krakenFuturesOrder.getOrder().getSymbol())).limitPrice(krakenFuturesOrder.getOrder().getLimitPrice()).originalAmount(krakenFuturesOrder.getOrder().getQuantity()).id(krakenFuturesOrder.getOrder().getOrderId()).userReference(krakenFuturesOrder.getOrder().getCliOrdId()).orderStatus(KrakenFuturesAdapters.adaptOrderStatus(krakenFuturesOrder.getOrder().getStatus())).build();
    }

    public static Order.OrderStatus adaptOrderStatus(KrakenFuturesOrderStatus krakenFuturesOrderStatus) {
        Order.OrderStatus orderStatus = Order.OrderStatus.UNKNOWN;
        if (krakenFuturesOrderStatus.equals((Object)KrakenFuturesOrderStatus.REJECTED) || krakenFuturesOrderStatus.equals((Object)KrakenFuturesOrderStatus.TRIGGER_ACTIVATION_FAILURE)) {
            orderStatus = Order.OrderStatus.REJECTED;
        } else if (krakenFuturesOrderStatus.equals((Object)KrakenFuturesOrderStatus.CANCELLED)) {
            orderStatus = Order.OrderStatus.CANCELED;
        } else if (krakenFuturesOrderStatus.equals((Object)KrakenFuturesOrderStatus.ENTERED_BOOK)) {
            orderStatus = Order.OrderStatus.NEW;
        } else if (krakenFuturesOrderStatus.equals((Object)KrakenFuturesOrderStatus.FULLY_EXECUTED)) {
            orderStatus = Order.OrderStatus.FILLED;
        } else if (krakenFuturesOrderStatus.equals((Object)KrakenFuturesOrderStatus.TRIGGER_PLACED) || krakenFuturesOrderStatus.equals((Object)KrakenFuturesOrderStatus.untouched)) {
            orderStatus = Order.OrderStatus.OPEN;
        } else if (krakenFuturesOrderStatus.equals((Object)KrakenFuturesOrderStatus.partiallyFilled)) {
            orderStatus = Order.OrderStatus.PARTIALLY_FILLED;
        }
        return orderStatus;
    }

    public static OpenPositions adaptOpenPositions(KrakenFuturesOpenPositions krakenFuturesOpenPositions) {
        ArrayList openPositions = new ArrayList();
        krakenFuturesOpenPositions.getOpenPositions().forEach(krakenFuturesOpenPosition -> openPositions.add(new OpenPosition.Builder().instrument(KrakenFuturesAdapters.adaptInstrument(krakenFuturesOpenPosition.getSymbol())).type(krakenFuturesOpenPosition.getSide().equals("long") ? OpenPosition.Type.LONG : OpenPosition.Type.SHORT).size(krakenFuturesOpenPosition.getSize()).price(krakenFuturesOpenPosition.getPrice()).build()));
        return new OpenPositions(openPositions);
    }
}

