/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.krakenfutures.service;

import jakarta.ws.rs.NotSupportedException;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.OpenPositions;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.krakenfutures.KrakenFuturesAdapters;
import org.knowm.xchange.krakenfutures.dto.trade.KrakenFuturesCancelAllOrders;
import org.knowm.xchange.krakenfutures.service.KrakenFuturesTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelAllOrders;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderByInstrument;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamInstrument;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class KrakenFuturesTradeService
extends KrakenFuturesTradeServiceRaw
implements TradeService {
    public KrakenFuturesTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(null);
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        return KrakenFuturesAdapters.adaptOpenOrders(this.getKrakenFuturesOpenOrders());
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return this.placeKrakenFuturesLimitOrder(limitOrder).getOrderId();
    }

    public Class[] getRequiredCancelOrderParamClasses() {
        return new Class[]{CancelOrderByIdParams.class};
    }

    public OpenPositions getOpenPositions() throws IOException {
        return KrakenFuturesAdapters.adaptOpenPositions(this.getKrakenFuturesOpenPositions());
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        return this.placeKrakenFuturesMarketOrder(marketOrder).getOrderId();
    }

    public String placeStopOrder(StopOrder stopOrder) throws IOException {
        return this.placeKrakenFuturesStopOrder(stopOrder).getOrderId();
    }

    public String changeOrder(LimitOrder limitOrder) throws IOException {
        return this.changeKrakenFuturesOrder(limitOrder);
    }

    public Collection<String> cancelAllOrders(CancelAllOrders orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByInstrument) {
            return this.cancelAllOrdersByInstrument(((CancelOrderByInstrument)orderParams).getInstrument()).getCancelStatus().getOrderIds().stream().map(KrakenFuturesCancelAllOrders.KrakenFuturesOrderId::getOrderId).collect(Collectors.toList());
        }
        throw new NotSupportedException("OrderParams need to implement CancelOrderByInstrument interface.");
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new DefaultTradeHistoryParamInstrument();
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        return this.getKrakenFuturesOrdersStatuses(orderIds).getOrders().stream().map(KrakenFuturesAdapters::adaptKrakenFuturesOrder).collect(Collectors.toList());
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return this.cancelKrakenFuturesOrder(orderId).isSuccess();
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        throw new NotSupportedException("CancelOrderParams need to be instance of CancelOrderByIdParams.");
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        return KrakenFuturesAdapters.adaptFills(this.getKrakenFuturesFills());
    }
}

