/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.krakenfutures.service;

import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.Params;
import si.mazi.rescu.RestInvocation;

public class KrakenFuturesDigest
extends BaseParamsDigest {
    private KrakenFuturesDigest(byte[] secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA512");
    }

    public static KrakenFuturesDigest createInstance(String secretKeyBase64) {
        if (secretKeyBase64 != null) {
            return new KrakenFuturesDigest(Base64.getDecoder().decode(secretKeyBase64.getBytes()));
        }
        return null;
    }

    public String signMessage(String message) {
        MessageDigest sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Illegal algorithm (SHA-256) for post body digest. Check the implementation.");
        }
        sha256.update(message.getBytes());
        Mac mac512 = this.getMac();
        mac512.update(sha256.digest());
        return Base64.getEncoder().encodeToString(mac512.doFinal()).trim();
    }

    public String digestParams(RestInvocation restInvocation) {
        try {
            String message = URLDecoder.decode(((Params)restInvocation.getParamsMap().get(QueryParam.class)).asQueryString(), StandardCharsets.UTF_8.name()) + restInvocation.getParamValue(HeaderParam.class, "Nonce").toString() + restInvocation.getPath();
            return this.signMessage(message);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Bad encoding found on request query while hashing (SHA256) the POST data.", e);
        }
    }
}

