/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.krakenfutures.dto.marketData;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.krakenfutures.dto.KrakenFuturesResult;
import org.knowm.xchange.krakenfutures.dto.marketData.KrakenFuturesTicker;

public class KrakenFuturesTickers
extends KrakenFuturesResult {
    private final Date serverTime;
    private final List<KrakenFuturesTicker> tickers;

    public KrakenFuturesTickers(@JsonProperty(value="result") String result, @JsonProperty(value="serverTime") Date serverTime, @JsonProperty(value="error") String error, @JsonProperty(value="tickers") List<KrakenFuturesTicker> tickers) {
        super(result, error);
        this.serverTime = serverTime;
        this.tickers = tickers;
    }

    public KrakenFuturesTicker getTicker(String symbol) {
        if (this.isSuccess() && this.tickers != null) {
            for (KrakenFuturesTicker ticker : this.tickers) {
                if (ticker == null || !ticker.getSymbol().equalsIgnoreCase(symbol)) continue;
                return ticker;
            }
        }
        return null;
    }

    public Date getServerTime() {
        return this.serverTime;
    }

    public List<KrakenFuturesTicker> getTickers() {
        return this.tickers;
    }

    @Override
    public String toString() {
        return "KrakenFuturesTickers(serverTime=" + this.getServerTime() + ", tickers=" + this.getTickers() + ")";
    }
}

