/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.krakenfutures;

import java.io.IOException;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.krakenfutures.KrakenFuturesAdapters;
import org.knowm.xchange.krakenfutures.service.KrakenFuturesAccountService;
import org.knowm.xchange.krakenfutures.service.KrakenFuturesMarketDataService;
import org.knowm.xchange.krakenfutures.service.KrakenFuturesMarketDataServiceRaw;
import org.knowm.xchange.krakenfutures.service.KrakenFuturesTradeService;

public class KrakenFuturesExchange
extends BaseExchange
implements Exchange {
    private final String DEMO_URL = "https://demo-futures.kraken.com/derivatives";

    protected void initServices() {
        this.concludeHostParams(this.exchangeSpecification);
        this.marketDataService = new KrakenFuturesMarketDataService(this);
        this.accountService = new KrakenFuturesAccountService(this);
        this.tradeService = new KrakenFuturesTradeService(this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://futures.kraken.com/derivatives");
        exchangeSpecification.setHost("https://futures.kraken.com/");
        exchangeSpecification.setPort(443);
        exchangeSpecification.setExchangeName("KrakenFutures");
        exchangeSpecification.setExchangeDescription("KrakenFutures is a bitcoin derivatives exchange operated by Kraken Ltd.");
        return exchangeSpecification;
    }

    public void remoteInit() throws IOException, ExchangeException {
        this.exchangeMetaData = KrakenFuturesAdapters.adaptInstrumentsMetaData(((KrakenFuturesMarketDataServiceRaw)this.marketDataService).getKrakenFuturesInstruments());
    }

    private void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters() != null && Boolean.TRUE.equals(exchangeSpecification.getExchangeSpecificParametersItem("Use_Sandbox"))) {
            exchangeSpecification.setSslUri("https://demo-futures.kraken.com/derivatives");
        }
    }
}

