/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.service;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.OpenPositions;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.kraken.KrakenAdapters;
import org.knowm.xchange.kraken.KrakenUtils;
import org.knowm.xchange.kraken.dto.trade.KrakenOrder;
import org.knowm.xchange.kraken.dto.trade.KrakenTrade;
import org.knowm.xchange.kraken.service.KrakenTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderByUserReferenceParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsIdSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;
import org.knowm.xchange.utils.DateUtils;

public class KrakenTradeService
extends KrakenTradeServiceRaw
implements TradeService {
    public KrakenTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(null);
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        Map<String, KrakenOrder> krakenOrders = super.getKrakenOpenOrders();
        if (params != null && params instanceof OpenOrdersParamCurrencyPair) {
            OpenOrdersParamCurrencyPair openOrdersParamCurrencyPair = (OpenOrdersParamCurrencyPair)params;
            Map<String, KrakenOrder> filteredKrakenOrders = KrakenUtils.filterOpenOrdersByCurrencyPair(krakenOrders, openOrdersParamCurrencyPair.getCurrencyPair());
            return KrakenAdapters.adaptOpenOrders(filteredKrakenOrders);
        }
        return KrakenAdapters.adaptOpenOrders(krakenOrders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        return KrakenAdapters.adaptOrderId(super.placeKrakenMarketOrder(marketOrder));
    }

    public OpenPositions getOpenPositions() throws IOException {
        return KrakenAdapters.adaptOpenPositions(super.getKrakenOpenPositions());
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return KrakenAdapters.adaptOrderId(super.placeKrakenLimitOrder(limitOrder));
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return super.cancelKrakenOrder(orderId).getCount() > 0;
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        if (orderParams instanceof CancelOrderByUserReferenceParams) {
            return this.cancelOrder(((CancelOrderByUserReferenceParams)orderParams).getUserReference());
        }
        return false;
    }

    public Class[] getRequiredCancelOrderParamClasses() {
        return new Class[]{CancelOrderByIdParams.class, CancelOrderByUserReferenceParams.class};
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws ExchangeException, IOException {
        String start = null;
        String end = null;
        Long offset = null;
        Object currencyPair = null;
        if (params instanceof TradeHistoryParamOffset) {
            offset = ((TradeHistoryParamOffset)params).getOffset();
        }
        if (params instanceof TradeHistoryParamsIdSpan) {
            TradeHistoryParamsIdSpan idSpan = (TradeHistoryParamsIdSpan)params;
            start = idSpan.getStartId();
            end = idSpan.getEndId();
        }
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan timeSpan = (TradeHistoryParamsTimeSpan)params;
            start = DateUtils.toUnixTimeOptional((Date)timeSpan.getStartTime()).map(Object::toString).orElse(start);
            end = DateUtils.toUnixTimeOptional((Date)timeSpan.getEndTime()).map(Object::toString).orElse(end);
        }
        Map<String, KrakenTrade> krakenTradeHistory = this.getKrakenTradeHistory(null, false, start, end, offset).getTrades();
        if (params instanceof TradeHistoryParamCurrencyPair && ((TradeHistoryParamCurrencyPair)params).getCurrencyPair() != null) {
            krakenTradeHistory = KrakenUtils.filterTradeHistoryByCurrencyPair(krakenTradeHistory, ((TradeHistoryParamCurrencyPair)params).getCurrencyPair());
        }
        return KrakenAdapters.adaptTradesHistory(krakenTradeHistory);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new org.knowm.xchange.kraken.service.KrakenTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public Collection<Order> getOrder(OrderQueryParams ... orderQueryParams) throws IOException {
        return KrakenAdapters.adaptOrders(super.getOrders(TradeService.toOrderIds((OrderQueryParams[])orderQueryParams)));
    }

    @Deprecated
    public static class KrakenTradeHistoryParams
    extends DefaultTradeHistoryParamsTimeSpan
    implements TradeHistoryParamOffset,
    TradeHistoryParamsIdSpan {
        private Long offset;
        private String startId;
        private String endId;

        public Long getOffset() {
            return this.offset;
        }

        public void setOffset(Long offset) {
            this.offset = offset;
        }

        public String getStartId() {
            return this.startId;
        }

        public String getEndId() {
            return this.endId;
        }

        public void setStartId(String startId) {
            this.startId = startId;
        }

        public void setEndId(String endId) {
            this.endId = endId;
        }
    }
}

