/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.service;

import jakarta.ws.rs.FormParam;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class KrakenDigest
extends BaseParamsDigest {
    private KrakenDigest(byte[] secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA512");
    }

    public static KrakenDigest createInstance(String secretKeyBase64) {
        if (secretKeyBase64 != null) {
            return new KrakenDigest(Base64.getDecoder().decode(secretKeyBase64.getBytes()));
        }
        return null;
    }

    public String digestParams(RestInvocation restInvocation) {
        MessageDigest sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Illegal algorithm for post body digest. Check the implementation.");
        }
        sha256.update(restInvocation.getParamValue(FormParam.class, "nonce").toString().getBytes());
        sha256.update(restInvocation.getRequestBody().getBytes());
        Mac mac512 = this.getMac();
        mac512.update(("/" + restInvocation.getPath()).getBytes());
        mac512.update(sha256.digest());
        return Base64.getEncoder().encodeToString(mac512.doFinal()).trim();
    }
}

