/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.trade;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.dto.Order;

@JsonDeserialize(using=KrakenTypeDeserializer.class)
public enum KrakenType {
    BUY,
    SELL;

    private static final Map<String, KrakenType> fromString;

    public static KrakenType fromString(String typeString) {
        return fromString.get(typeString.toLowerCase());
    }

    public static KrakenType fromOrderType(Order.OrderType type) {
        return type == Order.OrderType.ASK ? SELL : BUY;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    static {
        fromString = new HashMap<String, KrakenType>();
        for (KrakenType type : KrakenType.values()) {
            fromString.put(type.toString(), type);
        }
        fromString.put("b", BUY);
        fromString.put("s", SELL);
    }

    static class KrakenTypeDeserializer
    extends JsonDeserializer<KrakenType> {
        KrakenTypeDeserializer() {
        }

        public KrakenType deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String typeString = node.textValue();
            return KrakenType.fromString(typeString);
        }
    }
}

