/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.trade;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.knowm.xchange.dto.Order;

public enum KrakenOrderFlags implements Order.IOrderFlags
{
    FCIB,
    FCIQ,
    NOMPP,
    POST,
    VIQC;

    private static final Map<String, KrakenOrderFlags> fromString;

    public static KrakenOrderFlags fromString(String orderTypeString) {
        return fromString.get(orderTypeString.toLowerCase());
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    static {
        fromString = new HashMap<String, KrakenOrderFlags>();
        for (KrakenOrderFlags orderFlag : KrakenOrderFlags.values()) {
            fromString.put(orderFlag.toString(), orderFlag);
        }
    }

    static class KrakenOrderFlagsDeserializer
    extends JsonDeserializer<Set<KrakenOrderFlags>> {
        KrakenOrderFlagsDeserializer() {
        }

        public Set<KrakenOrderFlags> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String orderFlagsString = node.textValue();
            EnumSet<KrakenOrderFlags> orderFlags = EnumSet.noneOf(KrakenOrderFlags.class);
            if (!orderFlagsString.isEmpty()) {
                for (String orderFlag : orderFlagsString.split(",")) {
                    orderFlags.add(KrakenOrderFlags.fromString(orderFlag));
                }
            }
            return orderFlags;
        }
    }
}

