/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import org.knowm.xchange.kraken.dto.marketdata.KrakenPublicOrder;

public class KrakenTicker {
    private final KrakenPublicOrder ask;
    private final KrakenPublicOrder bid;
    private final KrakenPublicOrder close;
    private final BigDecimal[] volume;
    private final BigDecimal[] volumeAvg;
    private final BigDecimal[] trades;
    private final BigDecimal[] low;
    private final BigDecimal[] high;
    private final BigDecimal open;

    public KrakenTicker(@JsonProperty(value="a") KrakenPublicOrder ask, @JsonProperty(value="b") KrakenPublicOrder bid, @JsonProperty(value="c") KrakenPublicOrder close, @JsonProperty(value="v") BigDecimal[] volume, @JsonProperty(value="p") BigDecimal[] volumeAvg, @JsonProperty(value="t") BigDecimal[] trades, @JsonProperty(value="l") BigDecimal[] low, @JsonProperty(value="h") BigDecimal[] high, @JsonProperty(value="o") BigDecimal open) {
        this.ask = ask;
        this.bid = bid;
        this.close = close;
        this.volume = volume;
        this.volumeAvg = volumeAvg;
        this.trades = trades;
        this.low = low;
        this.high = high;
        this.open = open;
    }

    public KrakenPublicOrder getAsk() {
        return this.ask;
    }

    public KrakenPublicOrder getBid() {
        return this.bid;
    }

    public KrakenPublicOrder getClose() {
        return this.close;
    }

    public BigDecimal getTodaysVolume() {
        return this.volume[0];
    }

    public BigDecimal get24HourVolume() {
        return this.volume[1];
    }

    public BigDecimal getTodaysVolumeAvg() {
        return this.volumeAvg[0];
    }

    public BigDecimal get24HourVolumeAvg() {
        return this.volumeAvg[1];
    }

    public BigDecimal getTodaysNumTrades() {
        return this.trades[0];
    }

    public BigDecimal get24HourNumTrades() {
        return this.trades[1];
    }

    public BigDecimal getTodaysLow() {
        return this.low[0];
    }

    public BigDecimal get24HourLow() {
        return this.low[1];
    }

    public BigDecimal getTodaysHigh() {
        return this.high[0];
    }

    public BigDecimal get24HourHigh() {
        return this.high[1];
    }

    public BigDecimal getOpen() {
        return this.open;
    }

    public String toString() {
        return "KrakenTicker [ask=" + this.ask + ", bid=" + this.bid + ", close=" + this.close + ", volume=" + Arrays.toString(this.volume) + ", volumeAvg=" + Arrays.toString(this.volumeAvg) + ", trades=" + Arrays.toString(this.trades) + ", low=" + Arrays.toString(this.low) + ", high=" + Arrays.toString(this.high) + ", open=" + this.open + "]";
    }
}

