/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.kraken.dto.marketdata.KrakenSpread;

@JsonDeserialize(using=KrakenSpreadsDeserializer.class)
public class KrakenSpreads {
    private final List<KrakenSpread> spreads;
    private final long last;

    public KrakenSpreads(List<KrakenSpread> spreads, long last) {
        this.spreads = spreads;
        this.last = last;
    }

    public long getLast() {
        return this.last;
    }

    public List<KrakenSpread> getSpreads() {
        return this.spreads;
    }

    public String toString() {
        return "KrakenSpreads [spreads=" + this.spreads + ", last=" + this.last + "]";
    }

    static class KrakenSpreadsDeserializer
    extends JsonDeserializer<KrakenSpreads> {
        KrakenSpreadsDeserializer() {
        }

        public KrakenSpreads deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<KrakenSpread> krakenTrades = new ArrayList<KrakenSpread>();
            long last = 0L;
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator tradesResultIterator = node.fields();
            while (tradesResultIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)tradesResultIterator.next();
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                if (key == "last") {
                    last = value.asLong();
                    continue;
                }
                if (!value.isArray()) continue;
                for (JsonNode jsonSpreadNode : value) {
                    long time = jsonSpreadNode.path(0).asLong();
                    BigDecimal bid = new BigDecimal(jsonSpreadNode.path(1).asText());
                    BigDecimal ask = new BigDecimal(jsonSpreadNode.path(2).asText());
                    krakenTrades.add(new KrakenSpread(time, bid, ask));
                }
            }
            return new KrakenSpreads(krakenTrades, last);
        }
    }
}

