/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;

@JsonDeserialize(using=KrakenFeeDeserializer.class)
public class KrakenFee
implements Comparable<KrakenFee> {
    private final BigDecimal volume;
    private final BigDecimal percentFee;

    public KrakenFee(BigDecimal volume, BigDecimal percentFee) {
        this.volume = volume;
        this.percentFee = percentFee;
    }

    @Override
    public int compareTo(KrakenFee other) {
        return this.volume.compareTo(other.volume);
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getPercentFee() {
        return this.percentFee;
    }

    public String toString() {
        return "KrakenFee [volume=" + this.volume + ", percentFee=" + this.percentFee + "]";
    }

    static class KrakenFeeDeserializer
    extends JsonDeserializer<KrakenFee> {
        KrakenFeeDeserializer() {
        }

        public KrakenFee deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            BigDecimal volume = new BigDecimal(node.path(0).asText());
            BigDecimal fee = new BigDecimal(node.path(1).asText());
            return new KrakenFee(volume, fee);
        }
    }
}

