/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.kraken.dto.marketdata.KrakenFee;

@JsonDeserialize(builder=KrakenAssetPairBuilder.class)
public final class KrakenAssetPair {
    @JsonProperty(value="altname")
    private final String altName;
    @JsonProperty(value="wsname")
    private final String wsName;
    @JsonProperty(value="aclass_base")
    private final String classBase;
    private final String base;
    @JsonProperty(value="aclass_quote")
    private final String classQuote;
    private final String quote;
    @JsonProperty(value="lot")
    private final String volumeLotSize;
    @JsonProperty(value="pair_decimals")
    private final int pairScale;
    @JsonProperty(value="lot_decimals")
    private final int volumeLotScale;
    @JsonProperty(value="lot_multiplier")
    private final BigDecimal volumeMultiplier;
    private final List<String> leverage_buy;
    private final List<String> leverage_sell;
    private final List<KrakenFee> fees;
    private final List<KrakenFee> fees_maker;
    @JsonProperty(value="fee_volume_currency")
    private final String feeVolumeCurrency;
    @JsonProperty(value="margin_call")
    private final BigDecimal marginCall;
    @JsonProperty(value="margin_stop")
    private final BigDecimal marginStop;
    @JsonProperty(value="ordermin")
    private final BigDecimal orderMin;

    KrakenAssetPair(String altName, String wsName, String classBase, String base, String classQuote, String quote, String volumeLotSize, int pairScale, int volumeLotScale, BigDecimal volumeMultiplier, List<String> leverage_buy, List<String> leverage_sell, List<KrakenFee> fees, List<KrakenFee> fees_maker, String feeVolumeCurrency, BigDecimal marginCall, BigDecimal marginStop, BigDecimal orderMin) {
        this.altName = altName;
        this.wsName = wsName;
        this.classBase = classBase;
        this.base = base;
        this.classQuote = classQuote;
        this.quote = quote;
        this.volumeLotSize = volumeLotSize;
        this.pairScale = pairScale;
        this.volumeLotScale = volumeLotScale;
        this.volumeMultiplier = volumeMultiplier;
        this.leverage_buy = leverage_buy;
        this.leverage_sell = leverage_sell;
        this.fees = fees;
        this.fees_maker = fees_maker;
        this.feeVolumeCurrency = feeVolumeCurrency;
        this.marginCall = marginCall;
        this.marginStop = marginStop;
        this.orderMin = orderMin;
    }

    public static KrakenAssetPairBuilder builder() {
        return new KrakenAssetPairBuilder();
    }

    public String getAltName() {
        return this.altName;
    }

    public String getWsName() {
        return this.wsName;
    }

    public String getClassBase() {
        return this.classBase;
    }

    public String getBase() {
        return this.base;
    }

    public String getClassQuote() {
        return this.classQuote;
    }

    public String getQuote() {
        return this.quote;
    }

    public String getVolumeLotSize() {
        return this.volumeLotSize;
    }

    public int getPairScale() {
        return this.pairScale;
    }

    public int getVolumeLotScale() {
        return this.volumeLotScale;
    }

    public BigDecimal getVolumeMultiplier() {
        return this.volumeMultiplier;
    }

    public List<String> getLeverage_buy() {
        return this.leverage_buy;
    }

    public List<String> getLeverage_sell() {
        return this.leverage_sell;
    }

    public List<KrakenFee> getFees() {
        return this.fees;
    }

    public List<KrakenFee> getFees_maker() {
        return this.fees_maker;
    }

    public String getFeeVolumeCurrency() {
        return this.feeVolumeCurrency;
    }

    public BigDecimal getMarginCall() {
        return this.marginCall;
    }

    public BigDecimal getMarginStop() {
        return this.marginStop;
    }

    public BigDecimal getOrderMin() {
        return this.orderMin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KrakenAssetPair)) {
            return false;
        }
        KrakenAssetPair other = (KrakenAssetPair)o;
        if (this.getPairScale() != other.getPairScale()) {
            return false;
        }
        if (this.getVolumeLotScale() != other.getVolumeLotScale()) {
            return false;
        }
        String this$altName = this.getAltName();
        String other$altName = other.getAltName();
        if (this$altName == null ? other$altName != null : !this$altName.equals(other$altName)) {
            return false;
        }
        String this$wsName = this.getWsName();
        String other$wsName = other.getWsName();
        if (this$wsName == null ? other$wsName != null : !this$wsName.equals(other$wsName)) {
            return false;
        }
        String this$classBase = this.getClassBase();
        String other$classBase = other.getClassBase();
        if (this$classBase == null ? other$classBase != null : !this$classBase.equals(other$classBase)) {
            return false;
        }
        String this$base = this.getBase();
        String other$base = other.getBase();
        if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
            return false;
        }
        String this$classQuote = this.getClassQuote();
        String other$classQuote = other.getClassQuote();
        if (this$classQuote == null ? other$classQuote != null : !this$classQuote.equals(other$classQuote)) {
            return false;
        }
        String this$quote = this.getQuote();
        String other$quote = other.getQuote();
        if (this$quote == null ? other$quote != null : !this$quote.equals(other$quote)) {
            return false;
        }
        String this$volumeLotSize = this.getVolumeLotSize();
        String other$volumeLotSize = other.getVolumeLotSize();
        if (this$volumeLotSize == null ? other$volumeLotSize != null : !this$volumeLotSize.equals(other$volumeLotSize)) {
            return false;
        }
        BigDecimal this$volumeMultiplier = this.getVolumeMultiplier();
        BigDecimal other$volumeMultiplier = other.getVolumeMultiplier();
        if (this$volumeMultiplier == null ? other$volumeMultiplier != null : !((Object)this$volumeMultiplier).equals(other$volumeMultiplier)) {
            return false;
        }
        List<String> this$leverage_buy = this.getLeverage_buy();
        List<String> other$leverage_buy = other.getLeverage_buy();
        if (this$leverage_buy == null ? other$leverage_buy != null : !((Object)this$leverage_buy).equals(other$leverage_buy)) {
            return false;
        }
        List<String> this$leverage_sell = this.getLeverage_sell();
        List<String> other$leverage_sell = other.getLeverage_sell();
        if (this$leverage_sell == null ? other$leverage_sell != null : !((Object)this$leverage_sell).equals(other$leverage_sell)) {
            return false;
        }
        List<KrakenFee> this$fees = this.getFees();
        List<KrakenFee> other$fees = other.getFees();
        if (this$fees == null ? other$fees != null : !((Object)this$fees).equals(other$fees)) {
            return false;
        }
        List<KrakenFee> this$fees_maker = this.getFees_maker();
        List<KrakenFee> other$fees_maker = other.getFees_maker();
        if (this$fees_maker == null ? other$fees_maker != null : !((Object)this$fees_maker).equals(other$fees_maker)) {
            return false;
        }
        String this$feeVolumeCurrency = this.getFeeVolumeCurrency();
        String other$feeVolumeCurrency = other.getFeeVolumeCurrency();
        if (this$feeVolumeCurrency == null ? other$feeVolumeCurrency != null : !this$feeVolumeCurrency.equals(other$feeVolumeCurrency)) {
            return false;
        }
        BigDecimal this$marginCall = this.getMarginCall();
        BigDecimal other$marginCall = other.getMarginCall();
        if (this$marginCall == null ? other$marginCall != null : !((Object)this$marginCall).equals(other$marginCall)) {
            return false;
        }
        BigDecimal this$marginStop = this.getMarginStop();
        BigDecimal other$marginStop = other.getMarginStop();
        if (this$marginStop == null ? other$marginStop != null : !((Object)this$marginStop).equals(other$marginStop)) {
            return false;
        }
        BigDecimal this$orderMin = this.getOrderMin();
        BigDecimal other$orderMin = other.getOrderMin();
        return !(this$orderMin == null ? other$orderMin != null : !((Object)this$orderMin).equals(other$orderMin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPairScale();
        result = result * 59 + this.getVolumeLotScale();
        String $altName = this.getAltName();
        result = result * 59 + ($altName == null ? 43 : $altName.hashCode());
        String $wsName = this.getWsName();
        result = result * 59 + ($wsName == null ? 43 : $wsName.hashCode());
        String $classBase = this.getClassBase();
        result = result * 59 + ($classBase == null ? 43 : $classBase.hashCode());
        String $base = this.getBase();
        result = result * 59 + ($base == null ? 43 : $base.hashCode());
        String $classQuote = this.getClassQuote();
        result = result * 59 + ($classQuote == null ? 43 : $classQuote.hashCode());
        String $quote = this.getQuote();
        result = result * 59 + ($quote == null ? 43 : $quote.hashCode());
        String $volumeLotSize = this.getVolumeLotSize();
        result = result * 59 + ($volumeLotSize == null ? 43 : $volumeLotSize.hashCode());
        BigDecimal $volumeMultiplier = this.getVolumeMultiplier();
        result = result * 59 + ($volumeMultiplier == null ? 43 : ((Object)$volumeMultiplier).hashCode());
        List<String> $leverage_buy = this.getLeverage_buy();
        result = result * 59 + ($leverage_buy == null ? 43 : ((Object)$leverage_buy).hashCode());
        List<String> $leverage_sell = this.getLeverage_sell();
        result = result * 59 + ($leverage_sell == null ? 43 : ((Object)$leverage_sell).hashCode());
        List<KrakenFee> $fees = this.getFees();
        result = result * 59 + ($fees == null ? 43 : ((Object)$fees).hashCode());
        List<KrakenFee> $fees_maker = this.getFees_maker();
        result = result * 59 + ($fees_maker == null ? 43 : ((Object)$fees_maker).hashCode());
        String $feeVolumeCurrency = this.getFeeVolumeCurrency();
        result = result * 59 + ($feeVolumeCurrency == null ? 43 : $feeVolumeCurrency.hashCode());
        BigDecimal $marginCall = this.getMarginCall();
        result = result * 59 + ($marginCall == null ? 43 : ((Object)$marginCall).hashCode());
        BigDecimal $marginStop = this.getMarginStop();
        result = result * 59 + ($marginStop == null ? 43 : ((Object)$marginStop).hashCode());
        BigDecimal $orderMin = this.getOrderMin();
        result = result * 59 + ($orderMin == null ? 43 : ((Object)$orderMin).hashCode());
        return result;
    }

    public String toString() {
        return "KrakenAssetPair(altName=" + this.getAltName() + ", wsName=" + this.getWsName() + ", classBase=" + this.getClassBase() + ", base=" + this.getBase() + ", classQuote=" + this.getClassQuote() + ", quote=" + this.getQuote() + ", volumeLotSize=" + this.getVolumeLotSize() + ", pairScale=" + this.getPairScale() + ", volumeLotScale=" + this.getVolumeLotScale() + ", volumeMultiplier=" + this.getVolumeMultiplier() + ", leverage_buy=" + this.getLeverage_buy() + ", leverage_sell=" + this.getLeverage_sell() + ", fees=" + this.getFees() + ", fees_maker=" + this.getFees_maker() + ", feeVolumeCurrency=" + this.getFeeVolumeCurrency() + ", marginCall=" + this.getMarginCall() + ", marginStop=" + this.getMarginStop() + ", orderMin=" + this.getOrderMin() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class KrakenAssetPairBuilder {
        private String altName;
        private String wsName;
        private String classBase;
        private String base;
        private String classQuote;
        private String quote;
        private String volumeLotSize;
        private int pairScale;
        private int volumeLotScale;
        private BigDecimal volumeMultiplier;
        private List<String> leverage_buy;
        private List<String> leverage_sell;
        private List<KrakenFee> fees;
        private List<KrakenFee> fees_maker;
        private String feeVolumeCurrency;
        private BigDecimal marginCall;
        private BigDecimal marginStop;
        private BigDecimal orderMin;

        KrakenAssetPairBuilder() {
        }

        @JsonProperty(value="altname")
        public KrakenAssetPairBuilder altName(String altName) {
            this.altName = altName;
            return this;
        }

        @JsonProperty(value="wsname")
        public KrakenAssetPairBuilder wsName(String wsName) {
            this.wsName = wsName;
            return this;
        }

        @JsonProperty(value="aclass_base")
        public KrakenAssetPairBuilder classBase(String classBase) {
            this.classBase = classBase;
            return this;
        }

        public KrakenAssetPairBuilder base(String base) {
            this.base = base;
            return this;
        }

        @JsonProperty(value="aclass_quote")
        public KrakenAssetPairBuilder classQuote(String classQuote) {
            this.classQuote = classQuote;
            return this;
        }

        public KrakenAssetPairBuilder quote(String quote) {
            this.quote = quote;
            return this;
        }

        @JsonProperty(value="lot")
        public KrakenAssetPairBuilder volumeLotSize(String volumeLotSize) {
            this.volumeLotSize = volumeLotSize;
            return this;
        }

        @JsonProperty(value="pair_decimals")
        public KrakenAssetPairBuilder pairScale(int pairScale) {
            this.pairScale = pairScale;
            return this;
        }

        @JsonProperty(value="lot_decimals")
        public KrakenAssetPairBuilder volumeLotScale(int volumeLotScale) {
            this.volumeLotScale = volumeLotScale;
            return this;
        }

        @JsonProperty(value="lot_multiplier")
        public KrakenAssetPairBuilder volumeMultiplier(BigDecimal volumeMultiplier) {
            this.volumeMultiplier = volumeMultiplier;
            return this;
        }

        public KrakenAssetPairBuilder leverage_buy(List<String> leverage_buy) {
            this.leverage_buy = leverage_buy;
            return this;
        }

        public KrakenAssetPairBuilder leverage_sell(List<String> leverage_sell) {
            this.leverage_sell = leverage_sell;
            return this;
        }

        public KrakenAssetPairBuilder fees(List<KrakenFee> fees) {
            this.fees = fees;
            return this;
        }

        public KrakenAssetPairBuilder fees_maker(List<KrakenFee> fees_maker) {
            this.fees_maker = fees_maker;
            return this;
        }

        @JsonProperty(value="fee_volume_currency")
        public KrakenAssetPairBuilder feeVolumeCurrency(String feeVolumeCurrency) {
            this.feeVolumeCurrency = feeVolumeCurrency;
            return this;
        }

        @JsonProperty(value="margin_call")
        public KrakenAssetPairBuilder marginCall(BigDecimal marginCall) {
            this.marginCall = marginCall;
            return this;
        }

        @JsonProperty(value="margin_stop")
        public KrakenAssetPairBuilder marginStop(BigDecimal marginStop) {
            this.marginStop = marginStop;
            return this;
        }

        @JsonProperty(value="ordermin")
        public KrakenAssetPairBuilder orderMin(BigDecimal orderMin) {
            this.orderMin = orderMin;
            return this;
        }

        public KrakenAssetPair build() {
            return new KrakenAssetPair(this.altName, this.wsName, this.classBase, this.base, this.classQuote, this.quote, this.volumeLotSize, this.pairScale, this.volumeLotScale, this.volumeMultiplier, this.leverage_buy, this.leverage_sell, this.fees, this.fees_maker, this.feeVolumeCurrency, this.marginCall, this.marginStop, this.orderMin);
        }

        public String toString() {
            return "KrakenAssetPair.KrakenAssetPairBuilder(altName=" + this.altName + ", wsName=" + this.wsName + ", classBase=" + this.classBase + ", base=" + this.base + ", classQuote=" + this.classQuote + ", quote=" + this.quote + ", volumeLotSize=" + this.volumeLotSize + ", pairScale=" + this.pairScale + ", volumeLotScale=" + this.volumeLotScale + ", volumeMultiplier=" + this.volumeMultiplier + ", leverage_buy=" + this.leverage_buy + ", leverage_sell=" + this.leverage_sell + ", fees=" + this.fees + ", fees_maker=" + this.fees_maker + ", feeVolumeCurrency=" + this.feeVolumeCurrency + ", marginCall=" + this.marginCall + ", marginStop=" + this.marginStop + ", orderMin=" + this.orderMin + ")";
        }
    }
}

