/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.account;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(using=LedgerTypeDeserializer.class)
public enum LedgerType {
    DEPOSIT,
    WITHDRAWAL,
    SETTLED,
    TRADE,
    MARGIN,
    CREDIT,
    STAKING,
    ROLLOVER,
    TRANSFER,
    ADJUSTMENT;

    private static final Map<String, LedgerType> fromString;

    public static LedgerType fromString(String ledgerTypeString) {
        LedgerType ledgerType = fromString.get(ledgerTypeString.toLowerCase());
        if (ledgerType == null) {
            throw new RuntimeException("Not supported kraken ledger type: " + ledgerTypeString);
        }
        return ledgerType;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    static {
        fromString = new HashMap<String, LedgerType>();
        for (LedgerType ledgerType : LedgerType.values()) {
            fromString.put(ledgerType.toString(), ledgerType);
        }
    }

    static class LedgerTypeDeserializer
    extends JsonDeserializer<LedgerType> {
        LedgerTypeDeserializer() {
        }

        public LedgerType deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String ledgerTypeString = node.textValue();
            return LedgerType.fromString(ledgerTypeString);
        }
    }
}

