/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken;

import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.kraken.KrakenAdapters;
import org.knowm.xchange.kraken.dto.marketdata.KrakenAsset;
import org.knowm.xchange.kraken.dto.marketdata.KrakenAssetPair;
import org.knowm.xchange.kraken.dto.trade.KrakenOrder;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderDescription;
import org.knowm.xchange.kraken.dto.trade.KrakenTrade;

public class KrakenUtils {
    private static final Map<String, CurrencyPair> assetPairMap = new HashMap<String, CurrencyPair>();
    private static final Map<CurrencyPair, String> assetPairMapReverse = new HashMap<CurrencyPair, String>();
    private static final Map<String, Currency> assetsMap = new HashMap<String, Currency>();
    private static final Map<Currency, String> assetsMapReverse = new HashMap<Currency, String>();
    private static final Map<String, String> discontinuedCurrencies = new HashMap<String, String>();

    private KrakenUtils() {
    }

    public static void setKrakenAssetPairs(Map<String, KrakenAssetPair> pairs) {
        if (assetPairMap.isEmpty()) {
            for (Map.Entry<String, KrakenAssetPair> entry : pairs.entrySet()) {
                if (entry.getKey().endsWith(".d")) continue;
                CurrencyPair pair = new CurrencyPair(KrakenUtils.translateKrakenCurrencyCode(entry.getValue().getBase()), KrakenUtils.translateKrakenCurrencyCode(entry.getValue().getQuote()));
                assetPairMap.put(entry.getKey(), pair);
                assetPairMapReverse.put(pair, entry.getKey());
            }
        }
    }

    public static void setKrakenAssets(Map<String, KrakenAsset> assetSource) {
        if (assetsMap.isEmpty()) {
            for (Map.Entry<String, KrakenAsset> entry : assetSource.entrySet()) {
                assetsMap.put(entry.getKey(), Currency.getInstance((String)entry.getValue().getAltName()));
                assetsMapReverse.put(Currency.getInstance((String)entry.getValue().getAltName()), entry.getKey());
            }
        }
    }

    public static String createKrakenCurrencyPair(CurrencyPair currencyPair) {
        return assetPairMapReverse.get(currencyPair);
    }

    public static CurrencyPair translateKrakenCurrencyPair(String currencyPairIn) {
        CurrencyPair pair = assetPairMap.get(currencyPairIn);
        if (pair == null && currencyPairIn.length() >= 5 && !currencyPairIn.contains(".")) {
            Currency counter;
            int firstCurrencyLength = currencyPairIn.length() - 3;
            Currency base = Currency.getInstance((String)currencyPairIn.substring(0, firstCurrencyLength));
            if (base.getCommonlyUsedCurrency() != null) {
                base = base.getCommonlyUsedCurrency();
            }
            if ((counter = Currency.getInstance((String)currencyPairIn.substring(firstCurrencyLength))).getCommonlyUsedCurrency() != null) {
                counter = counter.getCommonlyUsedCurrency();
            }
            pair = new CurrencyPair(base, counter);
        }
        return pair;
    }

    public static String createKrakenCurrencyPair(Currency tradableIdentifier, Currency currency) {
        return KrakenUtils.createKrakenCurrencyPair(new CurrencyPair(tradableIdentifier, currency));
    }

    public static String getKrakenCurrencyCode(Currency currency) {
        String krakenCode;
        if (currency.getIso4217Currency() != null) {
            currency = currency.getIso4217Currency();
        }
        if ((krakenCode = assetsMapReverse.get(currency)) == null) {
            throw new ExchangeException("Kraken does not support the currency code " + currency);
        }
        return krakenCode;
    }

    public static Currency translateKrakenCurrencyCode(String currencyIn) {
        if (discontinuedCurrencies.containsKey(currencyIn)) {
            return Currency.getInstance((String)discontinuedCurrencies.get(currencyIn));
        }
        Currency currencyOut = assetsMap.get(currencyIn);
        if (currencyOut == null) {
            throw new ExchangeException("Kraken does not support the currency code " + currencyIn);
        }
        return currencyOut.getCommonlyUsedCurrency();
    }

    public static void clearAssets() {
        assetPairMap.clear();
        assetPairMapReverse.clear();
        assetsMap.clear();
        assetsMapReverse.clear();
    }

    public static Map<String, KrakenOrder> filterOpenOrdersByCurrencyPair(Map<String, KrakenOrder> krakenOrders, CurrencyPair currencyPair) {
        HashMap<String, KrakenOrder> filteredKrakenOrders = new HashMap<String, KrakenOrder>();
        for (Map.Entry<String, KrakenOrder> krakenOrderEntry : krakenOrders.entrySet()) {
            KrakenOrder krakenOrder = krakenOrderEntry.getValue();
            KrakenOrderDescription orderDescription = krakenOrder.getOrderDescription();
            if (currencyPair == null || !currencyPair.equals((Object)KrakenAdapters.adaptCurrencyPair(orderDescription.getAssetPair()))) continue;
            filteredKrakenOrders.put(krakenOrderEntry.getKey(), krakenOrder);
        }
        return filteredKrakenOrders;
    }

    public static Map<String, KrakenTrade> filterTradeHistoryByCurrencyPair(Map<String, KrakenTrade> krakenTrades, CurrencyPair currencyPair) {
        HashMap<String, KrakenTrade> filteredTradeHistory = new HashMap<String, KrakenTrade>();
        for (Map.Entry<String, KrakenTrade> krakenTradeEntry : krakenTrades.entrySet()) {
            if (currencyPair == null || !currencyPair.equals((Object)KrakenAdapters.adaptCurrencyPair(krakenTradeEntry.getValue().getAssetPair()))) continue;
            filteredTradeHistory.put(krakenTradeEntry.getKey(), krakenTradeEntry.getValue());
        }
        return filteredTradeHistory;
    }

    static {
        discontinuedCurrencies.put("XICN", "ICN");
        discontinuedCurrencies.put("BSV", "BSV");
        discontinuedCurrencies.put("XDAO", "DAO");
        discontinuedCurrencies.put("XNMC", "NMC");
        discontinuedCurrencies.put("XXVN", "XVN");
        discontinuedCurrencies.put("ZKRW", "KRW");
    }
}

