/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken;

import java.io.IOException;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.kraken.KrakenAdapters;
import org.knowm.xchange.kraken.KrakenUtils;
import org.knowm.xchange.kraken.dto.marketdata.KrakenAssetPairs;
import org.knowm.xchange.kraken.dto.marketdata.KrakenAssets;
import org.knowm.xchange.kraken.service.KrakenAccountService;
import org.knowm.xchange.kraken.service.KrakenMarketDataService;
import org.knowm.xchange.kraken.service.KrakenMarketDataServiceRaw;
import org.knowm.xchange.kraken.service.KrakenTradeService;

public class KrakenExchange
extends BaseExchange
implements Exchange {
    protected void initServices() {
        this.marketDataService = new KrakenMarketDataService(this);
        this.tradeService = new KrakenTradeService(this);
        this.accountService = new KrakenAccountService(this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://api.kraken.com");
        exchangeSpecification.setHost("api.kraken.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Kraken");
        exchangeSpecification.setExchangeDescription("Kraken is a Bitcoin exchange operated by Payward, Inc.");
        return exchangeSpecification;
    }

    public void remoteInit() throws IOException {
        KrakenAssetPairs assetPairs = ((KrakenMarketDataServiceRaw)this.marketDataService).getKrakenAssetPairs(new CurrencyPair[0]);
        KrakenAssets assets = ((KrakenMarketDataServiceRaw)this.marketDataService).getKrakenAssets(new Currency[0]);
        KrakenUtils.clearAssets();
        this.exchangeMetaData = KrakenAdapters.adaptToExchangeMetaData(this.exchangeMetaData, assetPairs.getAssetPairMap(), assets.getAssetPairMap());
    }
}

