/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.Objects;
import org.knowm.xchange.idex.annotations.ApiModelProperty;

public class WithdrawReq {
    private String address;
    private String amount;
    private String token;
    private BigInteger nonce;
    private String s;
    private BigInteger v;
    private String r;

    public WithdrawReq address(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty(value="address")
    @ApiModelProperty(value="(address string) - The address you are transacting from")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public WithdrawReq amount(String amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @ApiModelProperty(value="(uint256) - The raw amount you are withdrawing, not adjusted for token precision")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public WithdrawReq token(String token) {
        this.token = token;
        return this;
    }

    @JsonProperty(value="token")
    @ApiModelProperty(value="(address string) - The address of the token you are withdrawing from, see earlier notes for ETH")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public WithdrawReq nonce(BigInteger nonce) {
        this.nonce = nonce;
        return this;
    }

    @JsonProperty(value="nonce")
    @ApiModelProperty(value="(uint256) - One time numeric value associated with your address")
    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public WithdrawReq s(String s) {
        this.s = s;
        return this;
    }

    @JsonProperty(value="s")
    @ApiModelProperty(value="")
    public String getS() {
        return this.s;
    }

    public void setS(String s) {
        this.s = s;
    }

    public WithdrawReq v(BigInteger v) {
        this.v = v;
        return this;
    }

    @JsonProperty(value="v")
    @ApiModelProperty(value="")
    public BigInteger getV() {
        return this.v;
    }

    public void setV(BigInteger v) {
        this.v = v;
    }

    public WithdrawReq r(String r) {
        this.r = r;
        return this;
    }

    @JsonProperty(value="r")
    @ApiModelProperty(value="")
    public String getR() {
        return this.r;
    }

    public void setR(String r) {
        this.r = r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WithdrawReq withdrawReq = (WithdrawReq)o;
        return Objects.equals(this.address, withdrawReq.address) && Objects.equals(this.amount, withdrawReq.amount) && Objects.equals(this.token, withdrawReq.token) && Objects.equals(this.nonce, withdrawReq.nonce) && Objects.equals(this.s, withdrawReq.s) && Objects.equals(this.v, withdrawReq.v) && Objects.equals(this.r, withdrawReq.r);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.amount, this.token, this.nonce, this.s, this.v, this.r);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WithdrawReq {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    s: ").append(this.toIndentedString(this.s)).append("\n");
        sb.append("    v: ").append(this.toIndentedString(this.v)).append("\n");
        sb.append("    r: ").append(this.toIndentedString(this.r)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

