/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.Objects;
import org.knowm.xchange.idex.annotations.ApiModelProperty;

public class TradeReq {
    private String orderHash;
    private String amount;
    private String nonce;
    private String address;
    private BigInteger v;
    private String r;
    private String s;

    public TradeReq orderHash(String orderHash) {
        this.orderHash = orderHash;
        return this;
    }

    @JsonProperty(value="orderHash")
    @ApiModelProperty(value="- This is the unsalted hash of the order you are filling. See raw in the example code given with in the section that describes the order API call. The orderHash property of an order can be retrieved from the API calls which return orders, but for higher security we recommend you derive the hash yourself from the order parameters.")
    public String getOrderHash() {
        return this.orderHash;
    }

    public void setOrderHash(String orderHash) {
        this.orderHash = orderHash;
    }

    public TradeReq amount(String amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @ApiModelProperty(value="- This is the amount of the order you are filling, the raw value not adjusted for precision IMPORTANT: THIS PROPERTY IS IN TERMS OF THE ORDER'S amountBuy PROPERTY. This is NOT the amount of tokenSell you are receiving, but the amount of tokenBuy you are filling the order with. Do not trade unless you fully understand this idea. The amount of the token you will receive as a result of the trade is proportional to the ratio between amountSell and amountBuy")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TradeReq nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    @JsonProperty(value="nonce")
    @ApiModelProperty(value="- One time numeric value associated with the trade. Note: if filling multiple orders in one trade, every nonce in the list of trades must be greater than the one in the previous item")
    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public TradeReq address(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty(value="address")
    @ApiModelProperty(value="- The address you are transacting from")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public TradeReq v(BigInteger v) {
        this.v = v;
        return this;
    }

    @JsonProperty(value="v")
    @ApiModelProperty(value="- ...")
    public BigInteger getV() {
        return this.v;
    }

    public void setV(BigInteger v) {
        this.v = v;
    }

    public TradeReq r(String r) {
        this.r = r;
        return this;
    }

    @JsonProperty(value="r")
    @ApiModelProperty(value="- 0x")
    public String getR() {
        return this.r;
    }

    public void setR(String r) {
        this.r = r;
    }

    public TradeReq s(String s) {
        this.s = s;
        return this;
    }

    @JsonProperty(value="s")
    @ApiModelProperty(value="- v, r, and s refer to the values produced by signing the message")
    public String getS() {
        return this.s;
    }

    public void setS(String s) {
        this.s = s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TradeReq tradeReq = (TradeReq)o;
        return Objects.equals(this.orderHash, tradeReq.orderHash) && Objects.equals(this.amount, tradeReq.amount) && Objects.equals(this.nonce, tradeReq.nonce) && Objects.equals(this.address, tradeReq.address) && Objects.equals(this.v, tradeReq.v) && Objects.equals(this.r, tradeReq.r) && Objects.equals(this.s, tradeReq.s);
    }

    public int hashCode() {
        return Objects.hash(this.orderHash, this.amount, this.nonce, this.address, this.v, this.r, this.s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TradeReq {\n");
        sb.append("    orderHash: ").append(this.toIndentedString(this.orderHash)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    v: ").append(this.toIndentedString(this.v)).append("\n");
        sb.append("    r: ").append(this.toIndentedString(this.r)).append("\n");
        sb.append("    s: ").append(this.toIndentedString(this.s)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

