/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.knowm.xchange.idex.annotations.ApiModelProperty;

public class TradeHistoryReq {
    private String market;
    private String address;
    private String start;
    private String end;

    public TradeHistoryReq market(String market) {
        this.market = market;
        return this;
    }

    @JsonProperty(value="market")
    @ApiModelProperty(value="(string) - If specified, will return an array of trade objects for the market, if omitted, will return an object of arrays of trade objects keyed by each market")
    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public TradeHistoryReq address(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty(value="address")
    @ApiModelProperty(value="(address string) - If specified, return value will only include trades that involve the address as the maker or taker. Note: if specified the type property of the trade objects will refer to the action on the market taken relative to the user, not relative to the market. This behavior is designed to mimic the My Trades section of the IDEX appication, also to mimic the behavior of the private returnTradeHistory API call on Poloniex")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public TradeHistoryReq start(String start) {
        this.start = start;
        return this;
    }

    @JsonProperty(value="start")
    @ApiModelProperty(value="(number) - The inclusive UNIX timestamp (seconds since epoch, not ms) marking the earliest trade that will be returned in the response, if omitted will default to 0")
    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public TradeHistoryReq end(String end) {
        this.end = end;
        return this;
    }

    @JsonProperty(value="end")
    @ApiModelProperty(value="(number) - The inclusive UNIX timestamp marking the latest trade that will be returned in the response. If omitted will default to the current timestamp")
    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TradeHistoryReq tradeHistoryReq = (TradeHistoryReq)o;
        return Objects.equals(this.market, tradeHistoryReq.market) && Objects.equals(this.address, tradeHistoryReq.address) && Objects.equals(this.start, tradeHistoryReq.start) && Objects.equals(this.end, tradeHistoryReq.end);
    }

    public int hashCode() {
        return Objects.hash(this.market, this.address, this.start, this.end);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TradeHistoryReq {\n");
        sb.append("    market: ").append(this.toIndentedString(this.market)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

