/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.Objects;
import org.knowm.xchange.idex.annotations.ApiModelProperty;

public class OrderReq {
    private String tokenBuy;
    private String amountBuy;
    private String tokenSell;
    private String amountSell;
    private String address;
    private BigInteger nonce;
    private BigInteger expires;
    private BigInteger v;
    private String r;
    private String s;

    public OrderReq tokenBuy(String tokenBuy) {
        this.tokenBuy = tokenBuy;
        return this;
    }

    @JsonProperty(value="tokenBuy")
    @ApiModelProperty(value="(address string) - The address of the token you will receive as a result of the trade")
    public String getTokenBuy() {
        return this.tokenBuy;
    }

    public void setTokenBuy(String tokenBuy) {
        this.tokenBuy = tokenBuy;
    }

    public OrderReq amountBuy(String amountBuy) {
        this.amountBuy = amountBuy;
        return this;
    }

    @JsonProperty(value="amountBuy")
    @ApiModelProperty(value="(uint256) - The amount of the token you will receive when the order is fully filled")
    public String getAmountBuy() {
        return this.amountBuy;
    }

    public void setAmountBuy(String amountBuy) {
        this.amountBuy = amountBuy;
    }

    public OrderReq tokenSell(String tokenSell) {
        this.tokenSell = tokenSell;
        return this;
    }

    @JsonProperty(value="tokenSell")
    @ApiModelProperty(value="(address string) - The address of the token you will lose as a result of the trade")
    public String getTokenSell() {
        return this.tokenSell;
    }

    public void setTokenSell(String tokenSell) {
        this.tokenSell = tokenSell;
    }

    public OrderReq amountSell(String amountSell) {
        this.amountSell = amountSell;
        return this;
    }

    @JsonProperty(value="amountSell")
    @ApiModelProperty(value="(uint256) - The amount of the token you will give up when the order is fully filled")
    public String getAmountSell() {
        return this.amountSell;
    }

    public void setAmountSell(String amountSell) {
        this.amountSell = amountSell;
    }

    public OrderReq address(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty(value="address")
    @ApiModelProperty(value="(address string) - The address you are posting the order from")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public OrderReq nonce(BigInteger nonce) {
        this.nonce = nonce;
        return this;
    }

    @JsonProperty(value="nonce")
    @ApiModelProperty(value="(uint256) - One time number associated with the limit order")
    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public OrderReq expires(BigInteger expires) {
        this.expires = expires;
        return this;
    }

    @JsonProperty(value="expires")
    @ApiModelProperty(value="(uint256) - DEPRECATED this property has no effect on your limit order but is still REQUIRED to submit a limit order as it is one of the parameters that is hashed. It must be a numeric type")
    public BigInteger getExpires() {
        return this.expires;
    }

    public void setExpires(BigInteger expires) {
        this.expires = expires;
    }

    public OrderReq v(BigInteger v) {
        this.v = v;
        return this;
    }

    @JsonProperty(value="v")
    @ApiModelProperty(value="")
    public BigInteger getV() {
        return this.v;
    }

    public void setV(BigInteger v) {
        this.v = v;
    }

    public OrderReq r(String r) {
        this.r = r;
        return this;
    }

    @JsonProperty(value="r")
    @ApiModelProperty(value="")
    public String getR() {
        return this.r;
    }

    public void setR(String r) {
        this.r = r;
    }

    public OrderReq s(String s) {
        this.s = s;
        return this;
    }

    @JsonProperty(value="s")
    @ApiModelProperty(value="")
    public String getS() {
        return this.s;
    }

    public void setS(String s) {
        this.s = s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderReq orderReq = (OrderReq)o;
        return Objects.equals(this.tokenBuy, orderReq.tokenBuy) && Objects.equals(this.amountBuy, orderReq.amountBuy) && Objects.equals(this.tokenSell, orderReq.tokenSell) && Objects.equals(this.amountSell, orderReq.amountSell) && Objects.equals(this.address, orderReq.address) && Objects.equals(this.nonce, orderReq.nonce) && Objects.equals(this.expires, orderReq.expires) && Objects.equals(this.v, orderReq.v) && Objects.equals(this.r, orderReq.r) && Objects.equals(this.s, orderReq.s);
    }

    public int hashCode() {
        return Objects.hash(this.tokenBuy, this.amountBuy, this.tokenSell, this.amountSell, this.address, this.nonce, this.expires, this.v, this.r, this.s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderReq {\n");
        sb.append("    tokenBuy: ").append(this.toIndentedString(this.tokenBuy)).append("\n");
        sb.append("    amountBuy: ").append(this.toIndentedString(this.amountBuy)).append("\n");
        sb.append("    tokenSell: ").append(this.toIndentedString(this.tokenSell)).append("\n");
        sb.append("    amountSell: ").append(this.toIndentedString(this.amountSell)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    expires: ").append(this.toIndentedString(this.expires)).append("\n");
        sb.append("    v: ").append(this.toIndentedString(this.v)).append("\n");
        sb.append("    r: ").append(this.toIndentedString(this.r)).append("\n");
        sb.append("    s: ").append(this.toIndentedString(this.s)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

