/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.Objects;
import org.knowm.xchange.idex.annotations.ApiModelProperty;

public class CancelReq {
    private String orderHash;
    private BigInteger nonce;
    private String address;
    private BigInteger v;
    private String r;
    private String s;

    public CancelReq orderHash(String orderHash) {
        this.orderHash = orderHash;
        return this;
    }

    @JsonProperty(value="orderHash")
    @ApiModelProperty(value="(256-bit hex string) - The raw hash of the order you are cancelling")
    public String getOrderHash() {
        return this.orderHash;
    }

    public void setOrderHash(String orderHash) {
        this.orderHash = orderHash;
    }

    public CancelReq nonce(BigInteger nonce) {
        this.nonce = nonce;
        return this;
    }

    @JsonProperty(value="nonce")
    @ApiModelProperty(value="(uint256) - One time number associated with the address")
    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public CancelReq address(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty(value="address")
    @ApiModelProperty(value="(address string) - The address you are sending the cancel from, must own the order")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public CancelReq v(BigInteger v) {
        this.v = v;
        return this;
    }

    @JsonProperty(value="v")
    @ApiModelProperty(value="- ...")
    public BigInteger getV() {
        return this.v;
    }

    public void setV(BigInteger v) {
        this.v = v;
    }

    public CancelReq r(String r) {
        this.r = r;
        return this;
    }

    @JsonProperty(value="r")
    @ApiModelProperty(value="- ...")
    public String getR() {
        return this.r;
    }

    public void setR(String r) {
        this.r = r;
    }

    public CancelReq s(String s) {
        this.s = s;
        return this;
    }

    @JsonProperty(value="s")
    @ApiModelProperty(value="- v, r, and s refer to the values produced by signing the message")
    public String getS() {
        return this.s;
    }

    public void setS(String s) {
        this.s = s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelReq cancelReq = (CancelReq)o;
        return Objects.equals(this.orderHash, cancelReq.orderHash) && Objects.equals(this.nonce, cancelReq.nonce) && Objects.equals(this.address, cancelReq.address) && Objects.equals(this.v, cancelReq.v) && Objects.equals(this.r, cancelReq.r) && Objects.equals(this.s, cancelReq.s);
    }

    public int hashCode() {
        return Objects.hash(this.orderHash, this.nonce, this.address, this.v, this.r, this.s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelReq {\n");
        sb.append("    orderHash: ").append(this.toIndentedString(this.orderHash)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    v: ").append(this.toIndentedString(this.v)).append("\n");
        sb.append("    r: ").append(this.toIndentedString(this.r)).append("\n");
        sb.append("    s: ").append(this.toIndentedString(this.s)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

