/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.idex.IdexExchange;
import org.knowm.xchange.idex.IdexSignature;
import org.knowm.xchange.idex.IdexTradeHistoryParams;
import org.knowm.xchange.idex.dto.IdexBuySell;
import org.knowm.xchange.idex.dto.OpenOrdersReq;
import org.knowm.xchange.idex.dto.OrderReq;
import org.knowm.xchange.idex.dto.ReturnContractAddressResponse;
import org.knowm.xchange.idex.dto.ReturnOpenOrdersResponse;
import org.knowm.xchange.idex.dto.TradeHistoryReq;
import org.knowm.xchange.idex.service.CancelApi;
import org.knowm.xchange.idex.service.OrderApi;
import org.knowm.xchange.idex.service.ReturnContractAddressApi;
import org.knowm.xchange.idex.service.ReturnOpenOrdersApi;
import org.knowm.xchange.idex.service.ReturnTradeHistoryApi;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.web3j.crypto.Sign;

public class IdexTradeService
extends BaseExchangeService
implements TradeService {
    private final ReturnOpenOrdersApi returnOpenOrdersApi;
    private final CancelApi cancelApi;
    private final ReturnTradeHistoryApi returnTradeHistoryApi;
    private OrderApi orderApi;
    private ReturnContractAddressApi returnContractAddressApi;
    private String apiKey;

    public IdexTradeService(IdexExchange idexExchange) {
        super((Exchange)idexExchange);
        this.returnOpenOrdersApi = (ReturnOpenOrdersApi)ExchangeRestProxyBuilder.forInterface(ReturnOpenOrdersApi.class, (ExchangeSpecification)this.exchange.getExchangeSpecification()).build();
        this.cancelApi = (CancelApi)ExchangeRestProxyBuilder.forInterface(CancelApi.class, (ExchangeSpecification)this.exchange.getExchangeSpecification()).build();
        this.returnTradeHistoryApi = (ReturnTradeHistoryApi)ExchangeRestProxyBuilder.forInterface(ReturnTradeHistoryApi.class, (ExchangeSpecification)this.exchange.getExchangeSpecification()).build();
        this.orderApi = (OrderApi)ExchangeRestProxyBuilder.forInterface(OrderApi.class, (ExchangeSpecification)this.exchange.getExchangeSpecification()).build();
        this.returnContractAddressApi = (ReturnContractAddressApi)ExchangeRestProxyBuilder.forInterface(ReturnContractAddressApi.class, (ExchangeSpecification)this.exchange.getExchangeSpecification()).build();
        this.apiKey = this.exchange.getExchangeSpecification().getApiKey();
    }

    public OpenOrders getOpenOrders() {
        ReturnOpenOrdersApi proxy = this.returnOpenOrdersApi;
        OpenOrders ret = null;
        try {
            ReturnOpenOrdersResponse openOrdersResponse = proxy.openOrders(new OpenOrdersReq().address(this.apiKey));
            ret = new OpenOrders(openOrdersResponse.stream().map(responseInner -> {
                Order.OrderType orderType = responseInner.getType() == IdexBuySell.BUY ? Order.OrderType.BID : Order.OrderType.ASK;
                String market = responseInner.getMarket();
                CurrencyPair currencyPair = IdexExchange.Companion.getCurrencyPair(market);
                return new LimitOrder.Builder(orderType, (Instrument)currencyPair).limitPrice(IdexExchange.Companion.safeParse(responseInner.getPrice())).originalAmount(IdexExchange.Companion.safeParse(responseInner.getAmount())).id(responseInner.getOrderHash()).build();
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public OpenOrders getOpenOrders(OpenOrdersParams openOrdersParams) {
        return this.getOpenOrders();
    }

    public boolean cancelOrder(String s) {
        throw new NotAvailableFromExchangeException();
    }

    public boolean cancelOrder(CancelOrderParams cancelOrderParams) {
        throw new NotAvailableFromExchangeException();
    }

    public UserTrades getTradeHistory(TradeHistoryParams tradeHistoryParams) {
        CurrencyPair currencyPairTmp = null;
        if (tradeHistoryParams instanceof TradeHistoryParamCurrencyPair) {
            currencyPairTmp = ((TradeHistoryParamCurrencyPair)tradeHistoryParams).getCurrencyPair();
        }
        CurrencyPair currencyPair = currencyPairTmp;
        UserTrades ret = null;
        try {
            List userTrades = this.returnTradeHistoryApi.tradeHistory((TradeHistoryReq)tradeHistoryParams).stream().map(tradeHistoryItem -> UserTrade.builder().originalAmount(IdexExchange.Companion.safeParse(tradeHistoryItem.getAmount())).price(IdexExchange.Companion.safeParse(tradeHistoryItem.getPrice())).currencyPair(currencyPair).timestamp(new Date(tradeHistoryItem.getTimestamp().longValue() * 1000L)).id(tradeHistoryItem.getTransactionHash()).type(tradeHistoryItem.getType() == IdexBuySell.BUY ? Order.OrderType.BID : Order.OrderType.ASK).build()).sorted(Comparator.comparing(Trade::getTimestamp)).collect(Collectors.toList());
            return new UserTrades(userTrades, Trades.TradeSortType.SortByTimestamp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public OpenOrdersParams createOpenOrdersParams() {
        throw new NotAvailableFromExchangeException();
    }

    public void verifyOrder(LimitOrder limitOrder) {
        throw new NotAvailableFromExchangeException();
    }

    public void verifyOrder(MarketOrder marketOrder) {
        throw new NotAvailableFromExchangeException();
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new IdexTradeHistoryParams(this.apiKey);
    }

    public String placeMarketOrder(MarketOrder marketOrder) {
        throw new NotAvailableFromExchangeException();
    }

    public String placeStopOrder(StopOrder stopOrder) {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder placeOrder) {
        Order.OrderType type = placeOrder.getType();
        Currency baseCurrency = placeOrder.getCurrencyPair().base;
        Currency counterCurrency = placeOrder.getCurrencyPair().counter;
        BigDecimal originalAmount = placeOrder.getOriginalAmount();
        BigDecimal limitPrice = placeOrder.getLimitPrice();
        OrderReq orderReq = this.createNormalizedLimitOrderReq(baseCurrency, counterCurrency, type, limitPrice, originalAmount, null, null, null);
        try {
            this.orderApi.order(orderReq).getOrderHash();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public final OrderReq createNormalizedLimitOrderReq(Currency baseCurrency, Currency counterCurrency, Order.OrderType type, BigDecimal limitPrice, BigDecimal originalAmount, String contractAddress, BigInteger nonce, BigInteger expires) {
        nonce = nonce == null ? BigInteger.valueOf((Long)this.exchange.getNonceFactory().createValue()) : nonce;
        contractAddress = contractAddress == null ? this.contractAddress().getAddress() : contractAddress;
        expires = expires == null ? BigInteger.valueOf(100000L) : expires;
        this.exchange.getExchangeMetaData().getCurrencies().get(baseCurrency);
        this.exchange.getExchangeMetaData().getCurrencies().get(counterCurrency);
        OrderReq orderReq = null;
        boolean untested = true;
        if (untested) {
            List<Currency> listOfCurrencies = Arrays.asList(baseCurrency, counterCurrency);
            if (type == Order.OrderType.BID) {
                Collections.reverse(listOfCurrencies);
            }
            IdexExchange.Companion.IdexCurrencyMeta buy_currency = (IdexExchange.Companion.IdexCurrencyMeta)((Object)this.exchange.getExchangeMetaData().getCurrencies().get(listOfCurrencies.get(0)));
            IdexExchange.Companion.IdexCurrencyMeta sell_currency = (IdexExchange.Companion.IdexCurrencyMeta)((Object)this.exchange.getExchangeMetaData().getCurrencies().get(listOfCurrencies.get(1)));
            BigDecimal divide = originalAmount.divide(limitPrice, MathContext.DECIMAL128);
            BigDecimal amount_buy = divide.multiply(new BigDecimal("1e" + buy_currency.getDecimals()), MathContext.DECIMAL128);
            BigDecimal amount_sell = originalAmount.multiply(new BigDecimal("1e" + sell_currency.getDecimals()), MathContext.DECIMAL128);
            String buyc = buy_currency.getAddress();
            String sellc = sell_currency.getAddress();
            List<List<String>> hash_data = Arrays.asList(Arrays.asList("contractAddress", contractAddress, "address"), Arrays.asList("tokenBuy", buyc, "address"), Arrays.asList("amountBuy", amount_buy.toString(), "uint256"), Arrays.asList("tokenSell", sellc, "address"), Arrays.asList("amountSell", amount_sell.toString(), "uint256"), Arrays.asList("expires", "" + expires, "uint256"), Arrays.asList("nonce", "" + nonce, "uint256"), Arrays.asList("address", "" + this.getApiKey(), "address"));
            Sign.SignatureData sig = IdexSignature.generateSignature(this.exchange.getExchangeSpecification().getSecretKey(), hash_data);
            byte[] v = sig.getV();
            byte[] r = sig.getR();
            byte[] s = sig.getS();
            orderReq = new OrderReq().address(this.getApiKey()).nonce(nonce).tokenBuy(buyc).amountBuy(amount_buy.toString()).tokenSell(sellc).amountSell(amount_sell.toString()).expires(expires).r("0x" + new String(Hex.toHexString((byte[])r))).s("0x" + new String(Hex.toHexString((byte[])s))).v(BigInteger.valueOf((long)v[0] & 0xFFL));
        }
        return orderReq;
    }

    ReturnContractAddressResponse contractAddress() {
        try {
            return this.returnContractAddressApi.contractAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

