/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex;

import java.util.Date;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.idex.dto.TradeHistoryReq;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;

public final class IdexTradeHistoryParams
extends TradeHistoryReq
implements TradeHistoryParams,
TradeHistoryParamsTimeSpan,
TradeHistoryParamCurrencyPair {
    public IdexTradeHistoryParams(String address) {
        this.setAddress(address);
    }

    public Date getStartTime() {
        return new Date(Long.valueOf(this.getStart()) * 1000L);
    }

    public void setStartTime(Date date) {
        this.setStart(String.valueOf(date.getTime() / 1000L));
    }

    public Date getEndTime() {
        return new Date(Long.valueOf(this.getEnd()) * 1000L);
    }

    public void setEndTime(Date date) {
        this.setEnd(String.valueOf(date.getTime() / 1000L));
    }

    public CurrencyPair getCurrencyPair() {
        String[] marketSplit = this.getMarket().split("_");
        String currencyCounter = marketSplit[0];
        String currencyBase = marketSplit[1];
        CurrencyPair currencyPair = new CurrencyPair(currencyBase, currencyCounter);
        return currencyPair;
    }

    public void setCurrencyPair(CurrencyPair currencyPair) {
        this.setMarket(currencyPair.counter.getSymbol() + "_" + currencyPair.base.getSymbol());
    }
}

