/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;

public class IdexSignature {
    static Sign.SignatureData generateSignature(String apiSecret, List<List<String>> data) {
        byte[] rawhash = null;
        byte[] bytes = null;
        String[] last = new String[1];
        try (ByteArrayOutputStream sig_arr = new ByteArrayOutputStream();){
            for (List<String> d : data) {
                String data1 = d.get(1);
                byte[] segment = new byte[]{};
                byte[] r = new byte[]{};
                last[0] = new LinkedList<String>(Arrays.asList(data1.toLowerCase().split("0x"))).getLast();
                switch (d.get(2)) {
                    case "address": {
                        segment = new byte[20];
                        r = new BigInteger(last[0], 16).toByteArray();
                        break;
                    }
                    case "uint256": {
                        segment = new byte[32];
                        r = new BigInteger(last[0], 10).toByteArray();
                    }
                }
                int segLen = segment.length;
                int rlen = Integer.min(Integer.max(segLen, r.length), r.length);
                int oversize = r.length - segLen;
                System.arraycopy(r, oversize > 0 ? oversize : 0, segment, oversize > 0 ? 0 : segLen - rlen, Integer.min(segLen, rlen));
                sig_arr.write(segment);
            }
            rawhash = Hash.sha3((byte[])sig_arr.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] saltBytes = "\u0019Ethereum Signed Message:\n32".getBytes();
        assert (new String(Hex.toHexString((byte[])saltBytes)).toLowerCase() == "19457468657265756d205369676e6564204d6573736167653a0a3332");
        byte[] salted = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byteArrayOutputStream.write(saltBytes);
            byteArrayOutputStream.write(rawhash);
            salted = bytes = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        last[0] = new LinkedList<String>(Arrays.asList(apiSecret.split("0x"))).getLast();
        BigInteger apiSecret1 = new BigInteger(last[0], 16);
        ECKeyPair ecKeyPair = ECKeyPair.create((BigInteger)apiSecret1);
        Sign.SignatureData signatureData = Sign.signMessage((byte[])salted, (ECKeyPair)ecKeyPair);
        return signatureData;
    }
}

