/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.dto.meta.RateLimit;
import org.knowm.xchange.idex.IdexAccountService;
import org.knowm.xchange.idex.IdexExchangeSpecification;
import org.knowm.xchange.idex.IdexMarketDataService;
import org.knowm.xchange.idex.IdexTradeService;
import org.knowm.xchange.idex.dto.NextNonceReq;
import org.knowm.xchange.idex.dto.ReturnCurrenciesResponse;
import org.knowm.xchange.idex.dto.ReturnNextNonceResponse;
import org.knowm.xchange.idex.dto.ReturnTickerRequestedWithNull;
import org.knowm.xchange.idex.service.ReturnNextNonceApi;
import si.mazi.rescu.SynchronizedValueFactory;

public class IdexExchange
extends BaseExchange {
    private ReturnCurrenciesResponse allCurrenciesStatic;
    InstrumentMetaData unavailableCPMeta = new InstrumentMetaData.Builder().build();
    private IdexAccountService idexAccountService;
    private IdexTradeService idexTradeService;
    private IdexMarketDataService idexMarketDataService;
    private ReturnNextNonceApi nextNonceApi;

    public final InstrumentMetaData getUnavailableCPMeta() {
        return this.unavailableCPMeta;
    }

    public final ExchangeMetaData getExchangeMetaData() {
        ReturnCurrenciesResponse allCurrenciesStatic = null;
        try {
            allCurrenciesStatic = IdexMarketDataService.Companion.allCurrenciesStatic();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LinkedHashMap currencyPairs = new LinkedHashMap();
        ReturnTickerRequestedWithNull allTickers = IdexMarketDataService.Companion.allTickers;
        allTickers.keySet().forEach(s -> currencyPairs.put(Companion.getCurrencyPair(s), this.unavailableCPMeta));
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        allCurrenciesStatic.forEach((key, value) -> linkedHashMap.put(Currency.getInstance((String)key), new Companion.IdexCurrencyMeta(0, BigDecimal.ZERO, value.getAddress(), value.getName(), value.getDecimals())));
        RateLimit[] publicRateLimits = new RateLimit[]{};
        return new ExchangeMetaData(currencyPairs, linkedHashMap, publicRateLimits, publicRateLimits, Boolean.FALSE);
    }

    public ReturnNextNonceApi getNextNonceApi() {
        if (null == this.nextNonceApi) {
            this.nextNonceApi = (ReturnNextNonceApi)ExchangeRestProxyBuilder.forInterface(ReturnNextNonceApi.class, (ExchangeSpecification)this.exchangeSpecification).build();
        }
        return this.nextNonceApi;
    }

    public IdexAccountService getAccountService() {
        if (null == this.idexAccountService) {
            this.idexAccountService = new IdexAccountService(this);
        }
        return this.idexAccountService;
    }

    public IdexMarketDataService getMarketDataService() {
        if (null == this.idexMarketDataService) {
            this.idexMarketDataService = new IdexMarketDataService(this);
        }
        return this.idexMarketDataService;
    }

    public IdexTradeService getTradeService() {
        if (null == this.idexTradeService) {
            this.idexTradeService = new IdexTradeService(this);
        }
        return this.idexTradeService;
    }

    protected void initServices() {
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return () -> {
            Long ret = null;
            try {
                ReturnNextNonceResponse var10000 = this.getNextNonceApi().nextNonce(new NextNonceReq().address(this.getExchangeSpecification().getApiKey()));
                ret = var10000.getNonce().longValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ret;
        };
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        return new IdexExchangeSpecification();
    }

    public static final class Companion
    extends Enum<Companion> {
        private static final /* synthetic */ Companion[] $VALUES;

        public static Companion[] values() {
            return (Companion[])$VALUES.clone();
        }

        public static Companion valueOf(String name) {
            return Enum.valueOf(Companion.class, name);
        }

        public static BigDecimal safeParse(String s) {
            BigDecimal ret = null;
            try {
                ret = new BigDecimal(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }

        public static String getMarket(CurrencyPair currencyPair) {
            return currencyPair.counter.getSymbol() + "_" + currencyPair.base.getSymbol();
        }

        public static CurrencyPair getCurrencyPair(String market) {
            Iterator<String> syms = Arrays.asList(market.split("_")).iterator();
            String currencyCounter = syms.next();
            String currencyBase = syms.next();
            CurrencyPair currencyPair = new CurrencyPair(currencyBase, currencyCounter);
            return currencyPair;
        }

        private static /* synthetic */ Companion[] $values() {
            return new Companion[0];
        }

        static {
            $VALUES = Companion.$values();
        }

        public static final class IdexCurrencyMeta
        extends CurrencyMetaData {
            private final String address;
            private final String name;
            private final BigInteger decimals;

            public IdexCurrencyMeta(int scale, BigDecimal withdrawalFee, String address, String name, BigInteger decimals) {
                super(Integer.valueOf(scale), withdrawalFee);
                this.address = address;
                this.name = name;
                this.decimals = decimals;
            }

            public final String getAddress() {
                return this.address;
            }

            public final String getName() {
                return this.name;
            }

            public final BigInteger getDecimals() {
                return this.decimals;
            }
        }
    }
}

