/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.idex;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.idex.IdexDepositsWithdrawalsParams;
import org.knowm.xchange.idex.IdexExchange;
import org.knowm.xchange.idex.IdexWithdraw;
import org.knowm.xchange.idex.dto.CompleteBalance;
import org.knowm.xchange.idex.dto.CompleteBalancesReq;
import org.knowm.xchange.idex.dto.DepositsWithdrawalsReq;
import org.knowm.xchange.idex.dto.ReturnCompleteBalancesResponse;
import org.knowm.xchange.idex.dto.ReturnDepositsWithdrawalsResponse;
import org.knowm.xchange.idex.dto.WithdrawReq;
import org.knowm.xchange.idex.dto.WithdrawResponse;
import org.knowm.xchange.idex.service.ReturnCompleteBalancesApi;
import org.knowm.xchange.idex.service.ReturnDepositsWithdrawalsApi;
import org.knowm.xchange.idex.service.WithdrawApi;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class IdexAccountService
extends BaseExchangeService
implements AccountService {
    private final ReturnCompleteBalancesApi returnCompleteBalancesApi;
    private final ReturnDepositsWithdrawalsApi returnDepositsWithdrawalsApi;
    private final WithdrawApi withdrawApi;
    private final String apiKey;

    public IdexAccountService(IdexExchange idexExchange) {
        super((Exchange)idexExchange);
        this.returnCompleteBalancesApi = (ReturnCompleteBalancesApi)ExchangeRestProxyBuilder.forInterface(ReturnCompleteBalancesApi.class, (ExchangeSpecification)idexExchange.getExchangeSpecification()).build();
        this.returnDepositsWithdrawalsApi = (ReturnDepositsWithdrawalsApi)ExchangeRestProxyBuilder.forInterface(ReturnDepositsWithdrawalsApi.class, (ExchangeSpecification)idexExchange.getExchangeSpecification()).build();
        this.withdrawApi = (WithdrawApi)ExchangeRestProxyBuilder.forInterface(WithdrawApi.class, (ExchangeSpecification)idexExchange.getExchangeSpecification()).build();
        this.apiKey = this.exchange.getExchangeSpecification().getApiKey();
    }

    public AccountInfo getAccountInfo() {
        AccountInfo ret = null;
        try {
            String s = this.apiKey.substring(0, 6) + "\u2026";
            ret = null;
            ReturnCompleteBalancesResponse returnBalancesPost = this.returnCompleteBalancesApi.completeBalances(new CompleteBalancesReq().address(this.apiKey));
            ret = new AccountInfo(new Wallet[]{Wallet.Builder.from((Collection)returnBalancesPost.entrySet().stream().map(entry -> new Balance(new Currency((String)entry.getKey()), null, ((CompleteBalance)entry.getValue()).getAvailable(), ((CompleteBalance)entry.getValue()).getOnOrders())).collect(Collectors.toList())).id(s).build()});
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return ret;
    }

    public String requestDepositAddress(Currency currency, String ... args) {
        return this.exchange.getExchangeSpecification().getApiKey();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) {
        List<FundingRecord> ret = null;
        if (!(params instanceof IdexDepositsWithdrawalsParams)) {
            throw new Error("getFundingHistory requires " + IdexDepositsWithdrawalsParams.class.getCanonicalName());
        }
        try {
            ret = this.mutableList(this.returnDepositsWithdrawalsApi.fundingHistory((DepositsWithdrawalsReq)params));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private List<FundingRecord> mutableList(ReturnDepositsWithdrawalsResponse returnDepositsWithdrawalsPost) {
        return Arrays.asList(returnDepositsWithdrawalsPost.getWithdrawals().stream().map(fundingLedger -> new FundingRecord(this.exchange.getExchangeSpecification().getApiKey(), new Date(Long.parseLong(fundingLedger.getTimestamp()) * 1000L), new Currency(fundingLedger.getCurrency()), IdexExchange.Companion.safeParse(fundingLedger.getAmount()), fundingLedger.getTransactionHash(), fundingLedger.getDepositNumber(), FundingRecord.Type.WITHDRAWAL, FundingRecord.Status.resolveStatus((String)fundingLedger.getStatus()), BigDecimal.ZERO, BigDecimal.ZERO, "")).collect(Collectors.toList()), returnDepositsWithdrawalsPost.getDeposits().stream().map(fundingLedger1 -> new FundingRecord(this.exchange.getExchangeSpecification().getApiKey(), new Date(Long.parseLong(fundingLedger1.getTimestamp()) * 1000L), new Currency(fundingLedger1.getCurrency()), IdexExchange.Companion.safeParse(fundingLedger1.getAmount()), fundingLedger1.getTransactionHash(), fundingLedger1.getDepositNumber(), FundingRecord.Type.DEPOSIT, FundingRecord.Status.resolveStatus((String)fundingLedger1.getStatus()), BigDecimal.ZERO, BigDecimal.ZERO, "")).collect(Collectors.toList())).stream().flatMap(Collection::stream).sorted(Comparator.comparing(FundingRecord::getDate)).collect(Collectors.toList());
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new IdexDepositsWithdrawalsParams(this.apiKey);
    }

    public String withdrawFunds(WithdrawFundsParams w) {
        WithdrawResponse withdraw;
        String ret = "error";
        if (w instanceof IdexWithdraw) {
            withdraw = null;
            try {
                withdraw = this.withdrawApi.withdraw((WithdrawReq)w);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new Error("withdraw method requires " + IdexWithdraw.class.getCanonicalName());
        }
        ret = withdraw.toString();
        return ret;
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) {
        throw new NotAvailableFromExchangeException();
    }
}

