/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.gateio.GateioExchange;
import org.knowm.xchange.gateio.GateioUtils;
import org.knowm.xchange.gateio.dto.GateioBaseResponse;
import org.knowm.xchange.gateio.dto.GateioOrderType;
import org.knowm.xchange.gateio.dto.trade.GateioOpenOrders;
import org.knowm.xchange.gateio.dto.trade.GateioOrderStatus;
import org.knowm.xchange.gateio.dto.trade.GateioPlaceOrderReturn;
import org.knowm.xchange.gateio.dto.trade.GateioTradeHistoryReturn;
import org.knowm.xchange.gateio.service.GateioBaseService;
import org.knowm.xchange.service.trade.params.CancelOrderByCurrencyPair;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;

public class GateioTradeServiceRaw
extends GateioBaseService {
    public GateioTradeServiceRaw(GateioExchange exchange) {
        super(exchange);
    }

    public String placeGateioLimitOrder(LimitOrder limitOrder) throws IOException {
        GateioOrderType type = limitOrder.getType() == Order.OrderType.BID ? GateioOrderType.BUY : GateioOrderType.SELL;
        return this.placeGateioLimitOrder(limitOrder.getCurrencyPair(), type, limitOrder.getLimitPrice(), limitOrder.getOriginalAmount());
    }

    public String placeGateioLimitOrder(CurrencyPair currencyPair, GateioOrderType orderType, BigDecimal rate, BigDecimal amount) throws IOException {
        String pair = this.formatCurrencyPair(currencyPair);
        GateioPlaceOrderReturn orderId = orderType.equals((Object)GateioOrderType.BUY) ? this.gateioAuthenticated.buy(pair, rate, amount, this.apiKey, this.signatureCreator) : this.gateioAuthenticated.sell(pair, rate, amount, this.apiKey, this.signatureCreator);
        return this.handleResponse(orderId).getOrderId();
    }

    public boolean cancelOrder(String orderId, CurrencyPair currencyPair) throws IOException {
        GateioBaseResponse cancelOrderResult = this.gateioAuthenticated.cancelOrder(orderId, GateioUtils.toPairString(currencyPair), this.apiKey, this.signatureCreator);
        return this.handleResponse(cancelOrderResult).isResult();
    }

    public boolean cancelAllOrders(String type, CurrencyPair currencyPair) throws IOException {
        GateioBaseResponse cancelAllOrdersResult = this.gateioAuthenticated.cancelAllOrders(type, this.formatCurrencyPair(currencyPair), this.apiKey, this.signatureCreator);
        return this.handleResponse(cancelAllOrdersResult).isResult();
    }

    public GateioOpenOrders getGateioOpenOrders() throws IOException {
        GateioOpenOrders gateioOpenOrdersReturn = this.gateioAuthenticated.getOpenOrders(this.apiKey, this.signatureCreator);
        return this.handleResponse(gateioOpenOrdersReturn);
    }

    public GateioOrderStatus getGateioOrderStatus(String orderId, CurrencyPair currencyPair) throws IOException {
        GateioOrderStatus orderStatus = this.gateioAuthenticated.getOrderStatus(orderId, GateioUtils.toPairString(currencyPair), this.apiKey, this.signatureCreator);
        return this.handleResponse(orderStatus);
    }

    public GateioTradeHistoryReturn getGateioTradeHistory(CurrencyPair currencyPair) throws IOException {
        GateioTradeHistoryReturn gateioTradeHistoryReturn = this.gateioAuthenticated.getUserTradeHistory(this.apiKey, this.signatureCreator, GateioUtils.toPairString(currencyPair));
        return this.handleResponse(gateioTradeHistoryReturn);
    }

    private String formatCurrencyPair(CurrencyPair currencyPair) {
        return String.format("%s_%s", currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode()).toLowerCase();
    }

    public static class GateioCancelOrderParams
    implements CancelOrderByIdParams,
    CancelOrderByCurrencyPair {
        public final CurrencyPair currencyPair;
        public final String orderId;

        public GateioCancelOrderParams(CurrencyPair currencyPair, String orderId) {
            this.currencyPair = currencyPair;
            this.orderId = orderId;
        }

        public String getOrderId() {
            return this.orderId;
        }

        public CurrencyPair getCurrencyPair() {
            return this.currencyPair;
        }
    }
}

