/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.gateio.GateioAdapters;
import org.knowm.xchange.gateio.GateioExchange;
import org.knowm.xchange.gateio.dto.trade.GateioOpenOrders;
import org.knowm.xchange.gateio.dto.trade.GateioOrderStatus;
import org.knowm.xchange.gateio.dto.trade.GateioTrade;
import org.knowm.xchange.gateio.service.GateioTradeServiceRaw;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByCurrencyPair;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.DefaultQueryOrderParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;

public class GateioTradeService
extends GateioTradeServiceRaw
implements TradeService {
    public GateioTradeService(GateioExchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        GateioOpenOrders openOrders = super.getGateioOpenOrders();
        List currencyPairs = ((GateioExchange)this.exchange).getExchangeInstruments();
        return GateioAdapters.adaptOpenOrders(openOrders, currencyPairs);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return String.valueOf(super.placeGateioLimitOrder(limitOrder));
    }

    public boolean cancelOrder(String orderId) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public Class[] getRequiredCancelOrderParamClasses() {
        return new Class[]{CancelOrderByIdParams.class, CancelOrderByCurrencyPair.class};
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams && orderParams instanceof CancelOrderByCurrencyPair) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId(), ((CancelOrderByCurrencyPair)orderParams).getCurrencyPair());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws ExchangeException, IOException {
        CurrencyPair pair = ((TradeHistoryParamCurrencyPair)params).getCurrencyPair();
        List<GateioTrade> userTrades = this.getGateioTradeHistory(pair).getTrades();
        return GateioAdapters.adaptUserTrades(userTrades);
    }

    public Collection<Order> getOrder(OrderQueryParams ... orderQueryParams) throws IOException {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (OrderQueryParams param : orderQueryParams) {
            if (!(param instanceof DefaultQueryOrderParamCurrencyPair)) {
                throw new NotAvailableFromExchangeException("getOrder in gateio needs orderId and currency pair");
            }
            DefaultQueryOrderParamCurrencyPair queryOrderParamCurrencyPair = (DefaultQueryOrderParamCurrencyPair)param;
            GateioOrderStatus gateioOrderStatus = this.getGateioOrderStatus(queryOrderParamCurrencyPair.getOrderId(), queryOrderParamCurrencyPair.getCurrencyPair());
            LimitOrder limitOrder = new LimitOrder(GateioAdapters.adaptOrderType(gateioOrderStatus.getType()), gateioOrderStatus.getInitialAmount(), gateioOrderStatus.getInitialAmount().subtract(gateioOrderStatus.getAmount()), (Instrument)gateioOrderStatus.getCurrencyPair(), gateioOrderStatus.getOrderNumber(), null, gateioOrderStatus.getInitialRate()){};
            limitOrder.setAveragePrice(gateioOrderStatus.getRate());
            orders.add((Order)limitOrder);
        }
        return orders;
    }

    public TradeHistoryParamCurrencyPair createTradeHistoryParams() {
        return new DefaultTradeHistoryParamCurrencyPair();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }
}

