/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.gateio.GateioAdapters;
import org.knowm.xchange.gateio.GateioExchange;
import org.knowm.xchange.gateio.dto.marketdata.GateioDepth;
import org.knowm.xchange.gateio.dto.marketdata.GateioTicker;
import org.knowm.xchange.gateio.dto.marketdata.GateioTradeHistory;
import org.knowm.xchange.gateio.service.GateioMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.marketdata.params.CurrencyPairsParam;
import org.knowm.xchange.service.marketdata.params.Params;

public class GateioMarketDataService
extends GateioMarketDataServiceRaw
implements MarketDataService {
    public GateioMarketDataService(GateioExchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        GateioTicker ticker = super.getBTERTicker(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode());
        return GateioAdapters.adaptTicker(currencyPair, ticker);
    }

    public List<Ticker> getTickers(Params params) throws IOException {
        ArrayList currencyPairs = new ArrayList();
        if (params instanceof CurrencyPairsParam) {
            currencyPairs.addAll(((CurrencyPairsParam)params).getCurrencyPairs());
        }
        return this.getGateioTickers().values().stream().filter(ticker -> currencyPairs.size() == 0 || currencyPairs.contains(ticker.getCurrencyPair())).collect(Collectors.toList());
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        GateioDepth gateioDepth = super.getBTEROrderBook(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode());
        return GateioAdapters.adaptOrderBook(gateioDepth, currencyPair);
    }

    public Map<CurrencyPair, OrderBook> getOrderBooks() throws IOException {
        Map<CurrencyPair, GateioDepth> gateioDepths = super.getGateioDepths();
        HashMap<CurrencyPair, OrderBook> orderBooks = new HashMap<CurrencyPair, OrderBook>(gateioDepths.size());
        gateioDepths.forEach((currencyPair, gateioDepth) -> {
            OrderBook orderBook = GateioAdapters.adaptOrderBook(gateioDepth, currencyPair);
            orderBooks.put((CurrencyPair)currencyPair, orderBook);
        });
        return orderBooks;
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        GateioTradeHistory tradeHistory = args != null && args.length > 0 && args[0] != null && args[0] instanceof String ? super.getBTERTradeHistorySince(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode(), (String)args[0]) : super.getBTERTradeHistory(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode());
        return GateioAdapters.adaptTrades(tradeHistory, currencyPair);
    }
}

