/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.service;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class GateioHmacPostBodyDigest
extends BaseParamsDigest {
    private GateioHmacPostBodyDigest(String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA512");
    }

    public static GateioHmacPostBodyDigest createInstance(String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new GateioHmacPostBodyDigest(secretKeyBase64);
    }

    public String digestParams(RestInvocation restInvocation) {
        try {
            String postBody = restInvocation.getRequestBody();
            postBody = postBody.replace('+', ' ');
            Mac mac = this.getMac();
            mac.update(postBody.getBytes("UTF-8"));
            return String.format("%0128x", new BigInteger(1, mac.doFinal()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Illegal encoding, check the code.", e);
        }
    }
}

