/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.gateio.GateioExchange;
import org.knowm.xchange.gateio.dto.GateioBaseResponse;
import org.knowm.xchange.gateio.dto.account.GateioDepositAddress;
import org.knowm.xchange.gateio.dto.account.GateioDepositsWithdrawals;
import org.knowm.xchange.gateio.dto.account.GateioFunds;
import org.knowm.xchange.gateio.service.GateioBaseService;

public class GateioAccountServiceRaw
extends GateioBaseService {
    public GateioAccountServiceRaw(GateioExchange exchange) {
        super(exchange);
    }

    public GateioFunds getGateioAccountInfo() throws IOException {
        GateioFunds gateioFunds = this.gateioAuthenticated.getFunds(((GateioExchange)this.exchange).getExchangeSpecification().getApiKey(), this.signatureCreator);
        return this.handleResponse(gateioFunds);
    }

    public GateioDepositAddress getGateioDepositAddress(Currency currency) throws IOException {
        GateioDepositAddress depositAddress = this.gateioAuthenticated.getDepositAddress(((GateioExchange)this.exchange).getExchangeSpecification().getApiKey(), this.signatureCreator, currency.getCurrencyCode());
        return depositAddress;
    }

    public String withdraw(Currency currency, BigDecimal amount, String baseAddress, String addressTag) throws IOException {
        String withdrawAddress = baseAddress;
        if (addressTag != null && addressTag.length() > 0) {
            withdrawAddress = withdrawAddress + " " + addressTag;
        }
        return this.withdraw(currency.getCurrencyCode(), amount, withdrawAddress);
    }

    public GateioDepositsWithdrawals getDepositsWithdrawals(Date start, Date end) throws IOException {
        GateioDepositsWithdrawals gateioDepositsWithdrawals = this.gateioAuthenticated.getDepositsWithdrawals(((GateioExchange)this.exchange).getExchangeSpecification().getApiKey(), this.signatureCreator, start == null ? null : Long.valueOf(start.getTime() / 1000L), end == null ? null : Long.valueOf(end.getTime() / 1000L));
        return this.handleResponse(gateioDepositsWithdrawals);
    }

    public String withdraw(String currency, BigDecimal amount, String address) throws IOException {
        GateioBaseResponse withdraw = this.gateioAuthenticated.withdraw(((GateioExchange)this.exchange).getExchangeSpecification().getApiKey(), this.signatureCreator, currency, amount, address);
        if (!withdraw.isResult()) {
            throw new ExchangeException(withdraw.getMessage());
        }
        return null;
    }
}

