/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.gateio.GateioAdapters;
import org.knowm.xchange.gateio.GateioExchange;
import org.knowm.xchange.gateio.dto.account.GateioDepositsWithdrawals;
import org.knowm.xchange.gateio.service.GateioAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.MoneroWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.RippleWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class GateioAccountService
extends GateioAccountServiceRaw
implements AccountService {
    public GateioAccountService(GateioExchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(new Wallet[]{GateioAdapters.adaptWallet(super.getGateioAccountInfo())});
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdraw(currency.getCurrencyCode(), amount, address);
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof RippleWithdrawFundsParams) {
            RippleWithdrawFundsParams xrpParams = (RippleWithdrawFundsParams)params;
            return this.withdraw(xrpParams.getCurrency(), xrpParams.getAmount(), xrpParams.getAddress(), xrpParams.getTag());
        }
        if (params instanceof MoneroWithdrawFundsParams) {
            MoneroWithdrawFundsParams xmrParams = (MoneroWithdrawFundsParams)params;
            return this.withdraw(xmrParams.getCurrency(), xmrParams.getAmount(), xmrParams.getAddress(), xmrParams.getPaymentId());
        }
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress());
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        return super.getGateioDepositAddress(currency).getBaseAddress();
    }

    public TradeHistoryParams createFundingHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        Date start = null;
        Date end = null;
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan timeSpan = (TradeHistoryParamsTimeSpan)params;
            start = timeSpan.getStartTime();
            end = timeSpan.getEndTime();
        }
        GateioDepositsWithdrawals depositsWithdrawals = this.getDepositsWithdrawals(start, end);
        return GateioAdapters.adaptDepositsWithdrawals(depositsWithdrawals);
    }
}

