/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;

@JsonDeserialize(using=GateioPublicOrderDeserializer.class)
public class GateioPublicOrder {
    private final BigDecimal price;
    private final BigDecimal amount;

    private GateioPublicOrder(BigDecimal price, BigDecimal amount) {
        this.price = price;
        this.amount = amount;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String toString() {
        return "GateioPublicOrder [price=" + this.price + ", amount=" + this.amount + "]";
    }

    static class GateioPublicOrderDeserializer
    extends JsonDeserializer<GateioPublicOrder> {
        GateioPublicOrderDeserializer() {
        }

        public GateioPublicOrder deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jp.getCodec();
            JsonNode tickerNode = (JsonNode)oc.readTree(jp);
            BigDecimal price = new BigDecimal(tickerNode.path(0).asText());
            BigDecimal amount = new BigDecimal(tickerNode.path(1).asText());
            return new GateioPublicOrder(price, amount);
        }
    }
}

