/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.dto.meta.WalletHealth;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.gateio.dto.GateioOrderType;
import org.knowm.xchange.gateio.dto.account.GateioDepositsWithdrawals;
import org.knowm.xchange.gateio.dto.account.GateioFunds;
import org.knowm.xchange.gateio.dto.marketdata.GateioCoin;
import org.knowm.xchange.gateio.dto.marketdata.GateioDepth;
import org.knowm.xchange.gateio.dto.marketdata.GateioFeeInfo;
import org.knowm.xchange.gateio.dto.marketdata.GateioMarketInfoWrapper;
import org.knowm.xchange.gateio.dto.marketdata.GateioPublicOrder;
import org.knowm.xchange.gateio.dto.marketdata.GateioTicker;
import org.knowm.xchange.gateio.dto.marketdata.GateioTradeHistory;
import org.knowm.xchange.gateio.dto.trade.GateioOpenOrder;
import org.knowm.xchange.gateio.dto.trade.GateioOpenOrders;
import org.knowm.xchange.gateio.dto.trade.GateioTrade;
import org.knowm.xchange.gateio.service.GateioMarketDataServiceRaw;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.DateUtils;

public final class GateioAdapters {
    private GateioAdapters() {
    }

    public static CurrencyPair adaptCurrencyPair(String pair) {
        String[] currencies = pair.toUpperCase().split("_");
        return new CurrencyPair(currencies[0], currencies[1]);
    }

    public static Ticker adaptTicker(CurrencyPair currencyPair, GateioTicker gateioTicker) {
        BigDecimal ask = gateioTicker.getLowestAsk();
        BigDecimal bid = gateioTicker.getHighestBid();
        BigDecimal last = gateioTicker.getLast();
        BigDecimal low = gateioTicker.getLow24hr();
        BigDecimal high = gateioTicker.getHigh24hr();
        BigDecimal baseVolume = gateioTicker.getQuoteVolume();
        BigDecimal quoteVolume = gateioTicker.getBaseVolume();
        BigDecimal percentageChange = gateioTicker.getPercentChange();
        return new Ticker.Builder().currencyPair(currencyPair).ask(ask).bid(bid).last(last).low(low).high(high).volume(baseVolume).quoteVolume(quoteVolume).percentageChange(percentageChange).build();
    }

    public static LimitOrder adaptOrder(GateioPublicOrder order, CurrencyPair currencyPair, Order.OrderType orderType) {
        return new LimitOrder(orderType, order.getAmount(), (Instrument)currencyPair, "", null, order.getPrice());
    }

    public static List<LimitOrder> adaptOrders(List<GateioPublicOrder> orders, CurrencyPair currencyPair, Order.OrderType orderType) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (GateioPublicOrder bterOrder : orders) {
            limitOrders.add(GateioAdapters.adaptOrder(bterOrder, currencyPair, orderType));
        }
        return limitOrders;
    }

    public static OrderBook adaptOrderBook(GateioDepth depth, CurrencyPair currencyPair) {
        List<LimitOrder> asks = GateioAdapters.adaptOrders(depth.getAsks(), currencyPair, Order.OrderType.ASK);
        Collections.reverse(asks);
        List<LimitOrder> bids = GateioAdapters.adaptOrders(depth.getBids(), currencyPair, Order.OrderType.BID);
        return new OrderBook(null, asks, bids);
    }

    public static LimitOrder adaptOrder(GateioOpenOrder order, Collection<Instrument> currencyPairs) {
        String[] currencyPairSplit = order.getCurrencyPair().split("_");
        CurrencyPair currencyPair = new CurrencyPair(currencyPairSplit[0], currencyPairSplit[1]);
        return new LimitOrder(order.getType().equals("sell") ? Order.OrderType.ASK : Order.OrderType.BID, order.getAmount(), (Instrument)currencyPair, order.getOrderNumber(), null, order.getRate());
    }

    public static OpenOrders adaptOpenOrders(GateioOpenOrders openOrders, Collection<Instrument> currencyPairs) {
        ArrayList<LimitOrder> adaptedOrders = new ArrayList<LimitOrder>();
        for (GateioOpenOrder openOrder : openOrders.getOrders()) {
            adaptedOrders.add(GateioAdapters.adaptOrder(openOrder, currencyPairs));
        }
        return new OpenOrders(adaptedOrders);
    }

    public static Order.OrderType adaptOrderType(GateioOrderType cryptoTradeOrderType) {
        return cryptoTradeOrderType.equals((Object)GateioOrderType.BUY) ? Order.OrderType.BID : Order.OrderType.ASK;
    }

    public static Trade adaptTrade(GateioTradeHistory.GateioPublicTrade trade, CurrencyPair currencyPair) {
        Order.OrderType orderType = GateioAdapters.adaptOrderType(trade.getType());
        Date timestamp = DateUtils.fromMillisUtc((long)(trade.getDate() * 1000L));
        return new Trade.Builder().type(orderType).originalAmount(trade.getAmount()).currencyPair(currencyPair).price(trade.getPrice()).timestamp(timestamp).id(trade.getTradeId()).build();
    }

    public static Trades adaptTrades(GateioTradeHistory tradeHistory, CurrencyPair currencyPair) {
        ArrayList<Trade> tradeList = new ArrayList<Trade>();
        long lastTradeId = 0L;
        for (GateioTradeHistory.GateioPublicTrade trade : tradeHistory.getTrades()) {
            long tradeId;
            String tradeIdString = trade.getTradeId();
            if (!tradeIdString.isEmpty() && (tradeId = Long.valueOf(tradeIdString).longValue()) > lastTradeId) {
                lastTradeId = tradeId;
            }
            Trade adaptedTrade = GateioAdapters.adaptTrade(trade, currencyPair);
            tradeList.add(adaptedTrade);
        }
        return new Trades(tradeList, lastTradeId, Trades.TradeSortType.SortByTimestamp);
    }

    public static Wallet adaptWallet(GateioFunds bterAccountInfo) {
        BigDecimal amount;
        Currency currency;
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (Map.Entry<String, BigDecimal> funds : bterAccountInfo.getAvailableFunds().entrySet()) {
            currency = Currency.getInstance((String)funds.getKey().toUpperCase());
            amount = funds.getValue();
            BigDecimal locked = bterAccountInfo.getLockedFunds().get(currency.toString());
            balances.add(new Balance(currency, null, amount, locked == null ? BigDecimal.ZERO : locked));
        }
        for (Map.Entry<String, BigDecimal> funds : bterAccountInfo.getLockedFunds().entrySet()) {
            currency = Currency.getInstance((String)funds.getKey().toUpperCase());
            if (!balances.stream().noneMatch(balance -> balance.getCurrency().equals((Object)currency))) continue;
            amount = funds.getValue();
            balances.add(new Balance(currency, null, BigDecimal.ZERO, amount));
        }
        return Wallet.Builder.from(balances).build();
    }

    public static UserTrades adaptUserTrades(List<GateioTrade> userTrades) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        for (GateioTrade userTrade : userTrades) {
            trades.add(GateioAdapters.adaptUserTrade(userTrade));
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static UserTrade adaptUserTrade(GateioTrade gateioTrade) {
        Order.OrderType orderType = GateioAdapters.adaptOrderType(gateioTrade.getType());
        Date timestamp = DateUtils.fromMillisUtc((long)(gateioTrade.getTimeUnix() * 1000L));
        CurrencyPair currencyPair = GateioAdapters.adaptCurrencyPair(gateioTrade.getPair());
        return UserTrade.builder().type(orderType).originalAmount(gateioTrade.getAmount()).currencyPair(currencyPair).price(gateioTrade.getRate()).timestamp(timestamp).id(gateioTrade.getTradeID()).orderId(gateioTrade.getOrderNumber()).build();
    }

    public static ExchangeMetaData adaptToExchangeMetaData(GateioMarketDataServiceRaw marketDataService) throws IOException {
        HashMap<CurrencyPair, InstrumentMetaData> currencyPairs = new HashMap<CurrencyPair, InstrumentMetaData>();
        HashMap<Currency, CurrencyMetaData> currencies = new HashMap<Currency, CurrencyMetaData>();
        for (Map.Entry<CurrencyPair, GateioMarketInfoWrapper.GateioMarketInfo> entry : marketDataService.getGateioMarketInfo().entrySet()) {
            CurrencyPair currencyPair = entry.getKey();
            GateioMarketInfoWrapper.GateioMarketInfo btermarketInfo = entry.getValue();
            currencyPairs.put(currencyPair, new InstrumentMetaData.Builder().tradingFee(btermarketInfo.getFee()).minimumAmount(btermarketInfo.getMinAmount()).priceScale(Integer.valueOf(btermarketInfo.getDecimalPlaces())).build());
        }
        if (marketDataService.getApiKey() != null) {
            Map<String, GateioFeeInfo> gateioFees = marketDataService.getGateioFees();
            Map<String, GateioCoin> coins = marketDataService.getGateioCoinInfo().getCoins();
            for (String coin : coins.keySet()) {
                GateioCoin gateioCoin = coins.get(coin);
                GateioFeeInfo gateioFeeInfo = gateioFees.get(coin);
                if (gateioCoin == null || gateioFeeInfo == null) continue;
                currencies.put(new Currency(coin), GateioAdapters.adaptCurrencyMetaData(gateioCoin, gateioFeeInfo));
            }
        }
        return new ExchangeMetaData(currencyPairs, currencies, null, null, null);
    }

    private static CurrencyMetaData adaptCurrencyMetaData(GateioCoin gateioCoin, GateioFeeInfo gateioFeeInfo) {
        WalletHealth walletHealth = WalletHealth.ONLINE;
        if (gateioCoin.isWithdrawDelayed()) {
            walletHealth = WalletHealth.UNKNOWN;
        } else if (gateioCoin.isDelisted() || gateioCoin.isWithdrawDisabled() && gateioCoin.isDepositDisabled()) {
            walletHealth = WalletHealth.OFFLINE;
        } else if (gateioCoin.isDepositDisabled()) {
            walletHealth = WalletHealth.DEPOSITS_DISABLED;
        } else if (gateioCoin.isWithdrawDisabled()) {
            walletHealth = WalletHealth.WITHDRAWALS_DISABLED;
        }
        return new CurrencyMetaData(Integer.valueOf(0), new BigDecimal(gateioFeeInfo.getWithdrawFix()), gateioFeeInfo.getWithdrawAmountMini(), walletHealth);
    }

    public static List<FundingRecord> adaptDepositsWithdrawals(GateioDepositsWithdrawals depositsWithdrawals) {
        ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
        depositsWithdrawals.getDeposits().forEach(d -> {
            FundingRecord r = new FundingRecord(d.address, d.getTimestamp(), Currency.getInstance((String)d.currency), d.amount, d.id, d.txid, FundingRecord.Type.DEPOSIT, GateioAdapters.status(d.status), null, null, null);
            result.add(r);
        });
        depositsWithdrawals.getWithdraws().forEach(w -> {
            FundingRecord r = new FundingRecord(w.address, w.getTimestamp(), Currency.getInstance((String)w.currency), w.amount, w.id, w.txid, FundingRecord.Type.WITHDRAWAL, GateioAdapters.status(w.status), null, null, null);
            result.add(r);
        });
        return result;
    }

    private static FundingRecord.Status status(String gateioStatus) {
        switch (gateioStatus) {
            case "DONE": {
                return FundingRecord.Status.COMPLETE;
            }
        }
        return FundingRecord.Status.PROCESSING;
    }
}

