/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.service;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.gateio.Gateio;
import org.knowm.xchange.gateio.GateioAuthenticated;
import org.knowm.xchange.gateio.GateioExchange;
import org.knowm.xchange.gateio.dto.GateioBaseResponse;
import org.knowm.xchange.gateio.service.GateioHmacPostBodyDigest;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.ParamsDigest;

public class GateioBaseService
extends BaseExchangeService<GateioExchange>
implements BaseService {
    protected final String apiKey;
    protected final Gateio gateio;
    protected final GateioAuthenticated gateioAuthenticated;
    protected final ParamsDigest signatureCreator;

    public GateioBaseService(GateioExchange exchange) {
        super((Exchange)exchange);
        this.gateio = (Gateio)ExchangeRestProxyBuilder.forInterface(Gateio.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.gateioAuthenticated = (GateioAuthenticated)ExchangeRestProxyBuilder.forInterface(GateioAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = GateioHmacPostBodyDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    protected <R extends GateioBaseResponse> R handleResponse(R response) {
        if (!response.isResult()) {
            throw new ExchangeException(response.getMessage());
        }
        return response;
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

