/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.gateio.GateioAdapters;
import org.knowm.xchange.gateio.dto.GateioBaseResponse;
import org.knowm.xchange.gateio.dto.GateioOrderType;

public class GateioOrderStatus
extends GateioBaseResponse {
    private final BTEROrderStatusInfo orderStatusInfo;

    private GateioOrderStatus(@JsonProperty(value="order") BTEROrderStatusInfo orderStatusInfo, @JsonProperty(value="result") boolean result, @JsonProperty(value="message") String msg) {
        super(result, msg);
        this.orderStatusInfo = orderStatusInfo;
    }

    public String getOrderNumber() {
        return this.orderStatusInfo.getOrderNumber();
    }

    public String getStatus() {
        return this.orderStatusInfo.getStatus();
    }

    public CurrencyPair getCurrencyPair() {
        return this.orderStatusInfo.getCurrencyPair();
    }

    public GateioOrderType getType() {
        return this.orderStatusInfo.getType();
    }

    public BigDecimal getRate() {
        return this.orderStatusInfo.getRate();
    }

    public BigDecimal getAmount() {
        return this.orderStatusInfo.getAmount();
    }

    public BigDecimal getInitialRate() {
        return this.orderStatusInfo.getInitialRate();
    }

    public BigDecimal getInitialAmount() {
        return this.orderStatusInfo.getInitialAmount();
    }

    @Override
    public String toString() {
        return this.orderStatusInfo.toString();
    }

    public static class BTEROrderStatusInfo {
        private final String orderNumber;
        private final String status;
        private final CurrencyPair currencyPair;
        private final GateioOrderType type;
        private final BigDecimal rate;
        private final BigDecimal amount;
        private final BigDecimal initialRate;
        private final BigDecimal initialAmount;

        private BTEROrderStatusInfo(@JsonProperty(value="orderNumber") String orderNumber, @JsonProperty(value="status") String status, @JsonProperty(value="currencyPair") String currencyPair, @JsonProperty(value="type") GateioOrderType type, @JsonProperty(value="rate") BigDecimal rate, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="initialRate") BigDecimal initialRate, @JsonProperty(value="initialAmount") BigDecimal initialAmount) {
            this.orderNumber = orderNumber;
            this.status = status;
            this.currencyPair = GateioAdapters.adaptCurrencyPair(currencyPair);
            this.type = type;
            this.rate = rate;
            this.amount = amount;
            this.initialRate = initialRate;
            this.initialAmount = initialAmount;
        }

        public String getOrderNumber() {
            return this.orderNumber;
        }

        public String getStatus() {
            return this.status;
        }

        public CurrencyPair getCurrencyPair() {
            return this.currencyPair;
        }

        public GateioOrderType getType() {
            return this.type;
        }

        public BigDecimal getRate() {
            return this.rate;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public BigDecimal getInitialRate() {
            return this.initialRate;
        }

        public BigDecimal getInitialAmount() {
            return this.initialAmount;
        }

        public String toString() {
            return "BTEROrderStatusInfo [id=" + this.orderNumber + ", status=" + this.status + ", currencyPair=" + this.currencyPair + ", type=" + (Object)((Object)this.type) + ", rate=" + this.rate + ", amount=" + this.amount + ", initialRate=" + this.initialRate + ", initialAmount=" + this.initialAmount + "]";
        }
    }
}

