/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.gateio.GateioAdapters;

@JsonDeserialize(using=BTERMarketInfoWrapperDeserializer.class)
public class GateioMarketInfoWrapper {
    private final Map<CurrencyPair, GateioMarketInfo> marketInfoMap;

    private GateioMarketInfoWrapper(Map<CurrencyPair, GateioMarketInfo> marketInfoMap) {
        this.marketInfoMap = marketInfoMap;
    }

    public Map<CurrencyPair, GateioMarketInfo> getMarketInfoMap() {
        return this.marketInfoMap;
    }

    public String toString() {
        return "GateioMarketInfoWrapper [marketInfoMap=" + this.marketInfoMap + "]";
    }

    static class BTERMarketInfoWrapperDeserializer
    extends JsonDeserializer<GateioMarketInfoWrapper> {
        BTERMarketInfoWrapperDeserializer() {
        }

        public GateioMarketInfoWrapper deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            HashMap<CurrencyPair, GateioMarketInfo> marketInfoMap = new HashMap<CurrencyPair, GateioMarketInfo>();
            ObjectCodec oc = jp.getCodec();
            JsonNode marketsNodeWrapper = (JsonNode)oc.readTree(jp);
            JsonNode marketNodeList = marketsNodeWrapper.path("pairs");
            if (marketNodeList.isArray()) {
                for (JsonNode marketNode : marketNodeList) {
                    Iterator iter = marketNode.fields();
                    if (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        CurrencyPair currencyPair = GateioAdapters.adaptCurrencyPair((String)entry.getKey());
                        JsonNode marketInfoData = (JsonNode)entry.getValue();
                        int decimalPlaces = marketInfoData.path("decimal_places").asInt();
                        BigDecimal minAmount = new BigDecimal(marketInfoData.path("min_amount").asText());
                        BigDecimal fee = new BigDecimal(marketInfoData.path("fee").asText());
                        GateioMarketInfo marketInfoObject = new GateioMarketInfo(currencyPair, decimalPlaces, minAmount, fee);
                        marketInfoMap.put(currencyPair, marketInfoObject);
                        continue;
                    }
                    throw new ExchangeException("Invalid market info response received from Gateio." + marketsNodeWrapper);
                }
            } else {
                throw new ExchangeException("Invalid market info response received from Gateio." + marketsNodeWrapper);
            }
            return new GateioMarketInfoWrapper(marketInfoMap);
        }
    }

    public static final class GateioMarketInfo {
        private final CurrencyPair currencyPair;
        private final int decimalPlaces;
        private final BigDecimal minAmount;
        private final BigDecimal fee;

        public GateioMarketInfo(CurrencyPair currencyPair, int decimalPlaces, BigDecimal minAmount, BigDecimal fee) {
            this.currencyPair = currencyPair;
            this.decimalPlaces = decimalPlaces;
            this.minAmount = minAmount;
            this.fee = fee;
        }

        public CurrencyPair getCurrencyPair() {
            return this.currencyPair;
        }

        public int getDecimalPlaces() {
            return this.decimalPlaces;
        }

        public BigDecimal getMinAmount() {
            return this.minAmount;
        }

        public BigDecimal getFee() {
            return this.fee;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GateioMarketInfo)) {
                return false;
            }
            GateioMarketInfo other = (GateioMarketInfo)o;
            if (this.getDecimalPlaces() != other.getDecimalPlaces()) {
                return false;
            }
            CurrencyPair this$currencyPair = this.getCurrencyPair();
            CurrencyPair other$currencyPair = other.getCurrencyPair();
            if (this$currencyPair == null ? other$currencyPair != null : !this$currencyPair.equals(other$currencyPair)) {
                return false;
            }
            BigDecimal this$minAmount = this.getMinAmount();
            BigDecimal other$minAmount = other.getMinAmount();
            if (this$minAmount == null ? other$minAmount != null : !((Object)this$minAmount).equals(other$minAmount)) {
                return false;
            }
            BigDecimal this$fee = this.getFee();
            BigDecimal other$fee = other.getFee();
            return !(this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDecimalPlaces();
            CurrencyPair $currencyPair = this.getCurrencyPair();
            result = result * 59 + ($currencyPair == null ? 43 : $currencyPair.hashCode());
            BigDecimal $minAmount = this.getMinAmount();
            result = result * 59 + ($minAmount == null ? 43 : ((Object)$minAmount).hashCode());
            BigDecimal $fee = this.getFee();
            result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
            return result;
        }

        public String toString() {
            return "GateioMarketInfoWrapper.GateioMarketInfo(currencyPair=" + this.getCurrencyPair() + ", decimalPlaces=" + this.getDecimalPlaces() + ", minAmount=" + this.getMinAmount() + ", fee=" + this.getFee() + ")";
        }
    }
}

