/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import org.knowm.xchange.gateio.dto.GateioBaseResponse;
import org.knowm.xchange.gateio.dto.account.GateioDepositAddress;
import org.knowm.xchange.gateio.dto.account.GateioDepositsWithdrawals;
import org.knowm.xchange.gateio.dto.account.GateioFunds;
import org.knowm.xchange.gateio.dto.marketdata.GateioFeeInfo;
import org.knowm.xchange.gateio.dto.trade.GateioOpenOrders;
import org.knowm.xchange.gateio.dto.trade.GateioOrderStatus;
import org.knowm.xchange.gateio.dto.trade.GateioPlaceOrderReturn;
import org.knowm.xchange.gateio.dto.trade.GateioTradeHistoryReturn;
import si.mazi.rescu.ParamsDigest;

@Path(value="api2/1")
@Consumes(value={"application/x-www-form-urlencoded"})
@Produces(value={"application/json"})
public interface GateioAuthenticated {
    @POST
    @Path(value="private/balances")
    public GateioFunds getFunds(@HeaderParam(value="KEY") String var1, @HeaderParam(value="SIGN") ParamsDigest var2) throws IOException;

    @POST
    @Path(value="private/depositAddress")
    public GateioDepositAddress getDepositAddress(@HeaderParam(value="KEY") String var1, @HeaderParam(value="SIGN") ParamsDigest var2, @FormParam(value="currency") String var3) throws IOException;

    @POST
    @Path(value="private/withdraw")
    public GateioBaseResponse withdraw(@HeaderParam(value="KEY") String var1, @HeaderParam(value="SIGN") ParamsDigest var2, @FormParam(value="currency") String var3, @FormParam(value="amount") BigDecimal var4, @FormParam(value="address") String var5) throws IOException;

    @POST
    @Path(value="private/cancelorder")
    public GateioBaseResponse cancelOrder(@FormParam(value="orderNumber") String var1, @FormParam(value="currencyPair") String var2, @HeaderParam(value="KEY") String var3, @HeaderParam(value="SIGN") ParamsDigest var4) throws IOException;

    @POST
    @Path(value="private/cancelAllOrders")
    public GateioBaseResponse cancelAllOrders(@FormParam(value="type") String var1, @FormParam(value="currencyPair") String var2, @HeaderParam(value="KEY") String var3, @HeaderParam(value="SIGN") ParamsDigest var4) throws IOException;

    @POST
    @Path(value="private/buy")
    public GateioPlaceOrderReturn buy(@FormParam(value="currencyPair") String var1, @FormParam(value="rate") BigDecimal var2, @FormParam(value="amount") BigDecimal var3, @HeaderParam(value="KEY") String var4, @HeaderParam(value="SIGN") ParamsDigest var5) throws IOException;

    @POST
    @Path(value="private/sell")
    public GateioPlaceOrderReturn sell(@FormParam(value="currencyPair") String var1, @FormParam(value="rate") BigDecimal var2, @FormParam(value="amount") BigDecimal var3, @HeaderParam(value="KEY") String var4, @HeaderParam(value="SIGN") ParamsDigest var5) throws IOException;

    @POST
    @Path(value="private/openOrders")
    public GateioOpenOrders getOpenOrders(@HeaderParam(value="KEY") String var1, @HeaderParam(value="SIGN") ParamsDigest var2) throws IOException;

    @POST
    @Path(value="private/tradeHistory")
    public GateioTradeHistoryReturn getUserTradeHistory(@HeaderParam(value="KEY") String var1, @HeaderParam(value="SIGN") ParamsDigest var2, @FormParam(value="currencyPair") String var3) throws IOException;

    @POST
    @Path(value="private/depositsWithdrawals")
    public GateioDepositsWithdrawals getDepositsWithdrawals(@HeaderParam(value="KEY") String var1, @HeaderParam(value="SIGN") ParamsDigest var2, @FormParam(value="start") Long var3, @FormParam(value="end") Long var4) throws IOException;

    @POST
    @Path(value="private/getorder")
    public GateioOrderStatus getOrderStatus(@FormParam(value="orderNumber") String var1, @FormParam(value="currencyPair") String var2, @HeaderParam(value="KEY") String var3, @HeaderParam(value="SIGN") ParamsDigest var4) throws IOException;

    @POST
    @Path(value="private/feelist")
    public Map<String, GateioFeeInfo> getFeeList(@HeaderParam(value="KEY") String var1, @HeaderParam(value="SIGN") ParamsDigest var2) throws IOException;
}

