/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gateio;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.gateio.dto.marketdata.GateioCandlestickHistory;
import org.knowm.xchange.gateio.dto.marketdata.GateioCoinInfoWrapper;
import org.knowm.xchange.gateio.dto.marketdata.GateioCurrencyPairs;
import org.knowm.xchange.gateio.dto.marketdata.GateioDepth;
import org.knowm.xchange.gateio.dto.marketdata.GateioMarketInfoWrapper;
import org.knowm.xchange.gateio.dto.marketdata.GateioTicker;
import org.knowm.xchange.gateio.dto.marketdata.GateioTradeHistory;

@Path(value="api2/1")
@Produces(value={"application/json"})
public interface Gateio {
    @GET
    @Path(value="marketinfo")
    public GateioMarketInfoWrapper getMarketInfo() throws IOException;

    @GET
    @Path(value="pairs")
    public GateioCurrencyPairs getPairs() throws IOException;

    @GET
    @Path(value="orderBooks")
    public Map<String, GateioDepth> getDepths() throws IOException;

    @GET
    @Path(value="tickers")
    public Map<String, GateioTicker> getTickers() throws IOException;

    @GET
    @Path(value="coininfo")
    public GateioCoinInfoWrapper getCoinInfo() throws IOException;

    @GET
    @Path(value="ticker/{ident}_{currency}")
    public GateioTicker getTicker(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2) throws IOException;

    @GET
    @Path(value="orderBook/{ident}_{currency}")
    public GateioDepth getFullDepth(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2) throws IOException;

    @GET
    @Path(value="tradeHistory/{ident}_{currency}")
    public GateioTradeHistory getTradeHistory(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2) throws IOException;

    @GET
    @Path(value="tradeHistory/{ident}_{currency}/{tradeId}")
    public GateioTradeHistory getTradeHistorySince(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2, @PathParam(value="tradeId") String var3) throws IOException;

    @GET
    @Path(value="candlestick2/{currency_pair}")
    public GateioCandlestickHistory getKlinesGate(@PathParam(value="currency_pair") String var1, @QueryParam(value="range_hour") Integer var2, @QueryParam(value="group_sec") Long var3) throws IOException;
}

